/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.config;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.TransientBlobRequestSigner;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.config.BlobStoreMapModule;
import org.jclouds.blobstore.config.BlobStoreObjectModule;
import org.jclouds.blobstore.internal.BlobStoreContextImpl;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.filesystem.FilesystemBlobStore;
import org.jclouds.filesystem.predicates.validators.FilesystemBlobKeyValidator;
import org.jclouds.filesystem.predicates.validators.FilesystemContainerNameValidator;
import org.jclouds.filesystem.predicates.validators.internal.FilesystemBlobKeyValidatorImpl;
import org.jclouds.filesystem.predicates.validators.internal.FilesystemContainerNameValidatorImpl;
import org.jclouds.filesystem.strategy.FilesystemStorageStrategy;
import org.jclouds.filesystem.strategy.internal.FilesystemStorageStrategyImpl;
import org.jclouds.filesystem.util.internal.FileSystemBlobUtilsImpl;
import org.jclouds.location.config.JustProviderLocationModule;

public class FilesystemBlobStoreContextModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<BlobStoreContext>(){}).to((TypeLiteral)new TypeLiteral<BlobStoreContextImpl<FilesystemBlobStore, AsyncBlobStore>>(){}).in(Scopes.SINGLETON);
        this.install((Module)new BlobStoreObjectModule());
        this.install((Module)new BlobStoreMapModule());
        this.bind(ConsistencyModel.class).toInstance((Object)ConsistencyModel.STRICT);
        this.bind(FilesystemStorageStrategy.class).to(FilesystemStorageStrategyImpl.class);
        this.bind(BlobUtils.class).to(FileSystemBlobUtilsImpl.class);
        this.bind(FilesystemBlobKeyValidator.class).to(FilesystemBlobKeyValidatorImpl.class);
        this.bind(FilesystemContainerNameValidator.class).to(FilesystemContainerNameValidatorImpl.class);
        this.bind(BlobRequestSigner.class).to(TransientBlobRequestSigner.class);
        this.install((Module)new JustProviderLocationModule());
    }

    @Provides
    @Singleton
    BlobStore provide(FilesystemBlobStore in) {
        return in;
    }
}

