/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.strategy.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Provider;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.internal.BlobBuilderImpl;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.crypto.Crypto;
import org.jclouds.encryption.internal.JCECrypto;
import org.jclouds.filesystem.predicates.validators.FilesystemBlobKeyValidator;
import org.jclouds.filesystem.predicates.validators.FilesystemContainerNameValidator;
import org.jclouds.filesystem.predicates.validators.internal.FilesystemBlobKeyValidatorImpl;
import org.jclouds.filesystem.predicates.validators.internal.FilesystemContainerNameValidatorImpl;
import org.jclouds.filesystem.strategy.FilesystemStorageStrategy;
import org.jclouds.filesystem.strategy.internal.FilesystemStorageStrategyImpl;
import org.jclouds.filesystem.utils.TestUtils;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.FilePayload;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="filesystem.FilesystemBlobUtilsTest", sequential=true)
public class FilesystemStorageStrategyImplTest {
    private static final String CONTAINER_NAME = "funambol-test";
    private static final String TARGET_CONTAINER_NAME = TestUtils.TARGET_BASE_DIR + "funambol-test";
    private static final String LOGGING_CONFIG_KEY = "java.util.logging.config.file";
    private static final String LOGGING_CONFIG_VALUE = "src/main/resources/logging.properties";
    private static final String FS = File.separator;
    private FilesystemStorageStrategy storageStrategy;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.storageStrategy = new FilesystemStorageStrategyImpl((Provider)new Provider<BlobBuilder>(){

            public BlobBuilder get() {
                try {
                    return new BlobBuilderImpl((Crypto)new JCECrypto());
                }
                catch (Exception e) {
                    return null;
                }
            }
        }, TestUtils.TARGET_BASE_DIR, (FilesystemContainerNameValidator)new FilesystemContainerNameValidatorImpl(), (FilesystemBlobKeyValidator)new FilesystemBlobKeyValidatorImpl());
        TestUtils.cleanDirectoryContent(TestUtils.TARGET_BASE_DIR);
    }

    @AfterMethod
    protected void tearDown() throws IOException {
        TestUtils.cleanDirectoryContent(TestUtils.TARGET_BASE_DIR);
    }

    @DataProvider
    public Object[][] ignoreOnWindows() {
        return TestUtils.isWindowsOs() ? TestUtils.NO_INVOCATIONS : TestUtils.SINGLE_NO_ARG_INVOCATION;
    }

    public void testCreateDirectory() {
        this.storageStrategy.createDirectory(CONTAINER_NAME, null);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, true);
        this.storageStrategy.createDirectory(CONTAINER_NAME, "subdir");
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + FS + "subdir", true);
        this.storageStrategy.createDirectory(CONTAINER_NAME, "subdir1" + FS);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + FS + "subdir1", true);
        this.storageStrategy.createDirectory(CONTAINER_NAME, FS + "subdir2");
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + FS + "subdir2", true);
        this.storageStrategy.createDirectory(CONTAINER_NAME, "subdir3" + FS + "subdir4");
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + FS + "subdir2", true);
    }

    public void testCreateDirectory_DirectoryAlreadyExists() {
        this.storageStrategy.createDirectory(CONTAINER_NAME, null);
        this.storageStrategy.createDirectory(CONTAINER_NAME, null);
    }

    @Test(dataProvider="ignoreOnWindows", description="see http://code.google.com/p/jclouds/issues/detail?id=737")
    public void testCreateDirectory_WrongDirectoryName() {
        try {
            this.storageStrategy.createDirectory(CONTAINER_NAME, "$%&!'`\\/");
            Assert.fail((String)"No exception thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCreateContainer() {
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, false);
        boolean result = this.storageStrategy.createContainer(CONTAINER_NAME);
        Assert.assertTrue((boolean)result, (String)"Container not created");
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, true);
    }

    public void testCreateContainer_ContainerAlreadyExists() {
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, false);
        boolean result = this.storageStrategy.createContainer(CONTAINER_NAME);
        Assert.assertTrue((boolean)result, (String)"Container not created");
        result = this.storageStrategy.createContainer(CONTAINER_NAME);
        Assert.assertFalse((boolean)result, (String)"Container not created");
    }

    public void testDeleteDirectory() throws IOException {
        TestUtils.createContainerAsDirectory(CONTAINER_NAME);
        TestUtils.createBlobsInContainer(CONTAINER_NAME, TestUtils.createRandomBlobKey("lev1" + FS + "lev2" + FS + "lev3" + FS, ".txt"), TestUtils.createRandomBlobKey("lev1" + FS + "lev2" + FS + "lev4" + FS, ".jpg"));
        this.storageStrategy.deleteDirectory(CONTAINER_NAME, "lev1" + FS + "lev2" + FS + "lev4");
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + FS + "lev1" + FS + "lev2" + FS + "lev4", false);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + FS + "lev1" + FS + "lev2", true);
        this.storageStrategy.deleteDirectory(CONTAINER_NAME, "lev1" + FS + "lev2" + FS + "lev3" + FS);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + FS + "lev1" + FS + "lev2" + FS + "lev3", false);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + FS + "lev1" + FS + "lev2", true);
        this.storageStrategy.deleteDirectory(CONTAINER_NAME, FS + "lev1");
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + FS + "lev1", false);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, true);
        TestUtils.createBlobsInContainer(CONTAINER_NAME, TestUtils.createRandomBlobKey("lev1" + FS + "lev2" + FS + "lev3" + FS, ".txt"), TestUtils.createRandomBlobKey("lev1" + FS + "lev2" + FS + "lev4" + FS, ".jpg"));
        this.storageStrategy.deleteDirectory(CONTAINER_NAME, null);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, false);
    }

    public void testDeleteDirectory_ErrorWhenNotExists() {
        try {
            this.storageStrategy.deleteDirectory(CONTAINER_NAME, null);
            Assert.fail((String)"No exception throwed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDirectoryExists() throws IOException {
        String SUBDIRECTORY_NAME = "ad" + FS + "sda" + FS + "asd";
        boolean result = this.storageStrategy.directoryExists(CONTAINER_NAME, null);
        Assert.assertFalse((boolean)result, (String)"Directory exist");
        TestUtils.createContainerAsDirectory(CONTAINER_NAME);
        result = this.storageStrategy.directoryExists(CONTAINER_NAME, null);
        Assert.assertTrue((boolean)result, (String)"Directory doesn't exist");
        result = this.storageStrategy.directoryExists(CONTAINER_NAME + FS, null);
        Assert.assertTrue((boolean)result, (String)"Directory doesn't exist");
        result = this.storageStrategy.directoryExists(CONTAINER_NAME, SUBDIRECTORY_NAME);
        Assert.assertFalse((boolean)result, (String)"Directory exist");
        TestUtils.createContainerAsDirectory(CONTAINER_NAME + FS + SUBDIRECTORY_NAME);
        result = this.storageStrategy.directoryExists(CONTAINER_NAME, SUBDIRECTORY_NAME);
        Assert.assertTrue((boolean)result, (String)"Directory doesn't exist");
        result = this.storageStrategy.directoryExists(CONTAINER_NAME, FS + SUBDIRECTORY_NAME);
        Assert.assertTrue((boolean)result, (String)"Directory doesn't exist");
        result = this.storageStrategy.directoryExists(CONTAINER_NAME, SUBDIRECTORY_NAME + FS);
        Assert.assertTrue((boolean)result, (String)"Directory doesn't exist");
        result = this.storageStrategy.directoryExists(CONTAINER_NAME + FS, FS + SUBDIRECTORY_NAME);
        Assert.assertTrue((boolean)result, (String)"Directory doesn't exist");
    }

    public void testClearContainer() throws IOException {
        this.storageStrategy.createContainer(CONTAINER_NAME);
        Set<String> blobs = TestUtils.createBlobsInContainer(CONTAINER_NAME, TestUtils.createRandomBlobKey("clean_container-", ".jpg"), TestUtils.createRandomBlobKey("bf" + FS + "sd" + FS + "as" + FS + "clean_container-", ".jpg"));
        for (String blob : blobs) {
            TestUtils.fileExists(TARGET_CONTAINER_NAME + FS + blob, true);
        }
        this.storageStrategy.clearContainer(CONTAINER_NAME);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, true);
        for (String blob : blobs) {
            TestUtils.fileExists(TARGET_CONTAINER_NAME + FS + blob, false);
        }
    }

    public void testClearContainer_NotExistingContainer() throws IOException {
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, false);
        this.storageStrategy.clearContainer(CONTAINER_NAME);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, false);
    }

    public void testClearContainerAndThenDeleteContainer() throws IOException {
        this.storageStrategy.createContainer(CONTAINER_NAME);
        Set<String> blobs = TestUtils.createBlobsInContainer(CONTAINER_NAME, TestUtils.createRandomBlobKey("clean_container-", ".jpg"), TestUtils.createRandomBlobKey("bf" + FS + "sd" + FS + "as" + FS + "clean_container-", ".jpg"));
        for (String blob : blobs) {
            TestUtils.fileExists(TARGET_CONTAINER_NAME + FS + blob, true);
        }
        this.storageStrategy.clearContainer(CONTAINER_NAME);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, true);
        for (String blob : blobs) {
            TestUtils.fileExists(TARGET_CONTAINER_NAME + FS + blob, false);
        }
        this.storageStrategy.deleteContainer(CONTAINER_NAME);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, false);
        Assert.assertFalse((boolean)this.storageStrategy.containerExists(CONTAINER_NAME), (String)"Container still exists");
    }

    public void testDeleteContainer() throws IOException {
        String BLOB_KEY1 = "blobName.jpg";
        String BLOB_KEY2 = "aa" + FS + "bb" + FS + "cc" + FS + "dd" + FS + "ee" + FS + "ff" + FS + "23" + FS + "blobName.jpg";
        boolean result = this.storageStrategy.createContainer(CONTAINER_NAME);
        TestUtils.createBlobsInContainer(CONTAINER_NAME, "blobName.jpg", BLOB_KEY2);
        this.storageStrategy.deleteContainer(CONTAINER_NAME);
        Assert.assertTrue((boolean)result, (String)"Cannot delete container");
        TestUtils.directoryExists(CONTAINER_NAME, false);
    }

    public void testDeleteContainer_EmptyContainer() {
        boolean result = this.storageStrategy.createContainer(CONTAINER_NAME);
        Assert.assertTrue((boolean)result, (String)"Cannot create container");
        this.storageStrategy.deleteContainer(CONTAINER_NAME);
        TestUtils.directoryExists(CONTAINER_NAME, false);
    }

    public void testDeleteContainer_ErrorWhenNotExists() {
        try {
            this.storageStrategy.deleteContainer(CONTAINER_NAME);
            Assert.fail((String)"Exception not throwed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetAllContainerNames() {
        Iterable resultList = this.storageStrategy.getAllContainerNames();
        Assert.assertNotNull((Object)resultList, (String)"Result is null");
        Assert.assertFalse((boolean)resultList.iterator().hasNext(), (String)"Containers detected");
        this.storageStrategy.createContainer("funambol-test1");
        this.storageStrategy.createContainer("funambol-test2");
        this.storageStrategy.createContainer("funambol-test3");
        ArrayList containers = new ArrayList();
        resultList = this.storageStrategy.getAllContainerNames();
        Iterator containersIterator = resultList.iterator();
        while (containersIterator.hasNext()) {
            containers.add(containersIterator.next());
        }
        Assert.assertEquals((int)containers.size(), (int)3, (String)"Different containers number");
        Assert.assertTrue((boolean)containers.contains("funambol-test1"), (String)"Containers doesn't exist");
        Assert.assertTrue((boolean)containers.contains("funambol-test2"), (String)"Containers doesn't exist");
        Assert.assertTrue((boolean)containers.contains("funambol-test3"), (String)"Containers doesn't exist");
    }

    public void testContainerExists() {
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, false);
        boolean result = this.storageStrategy.containerExists(CONTAINER_NAME);
        Assert.assertFalse((boolean)result, (String)"Container exists");
        this.storageStrategy.createContainer(CONTAINER_NAME);
        result = this.storageStrategy.containerExists(CONTAINER_NAME);
        Assert.assertTrue((boolean)result, (String)"Container exists");
    }

    public void testNewBlob() {
        String blobKey = TestUtils.createRandomBlobKey("blobtest-", ".txt");
        Blob newBlob = this.storageStrategy.newBlob(blobKey);
        Assert.assertNotNull((Object)newBlob, (String)"Created blob was null");
        Assert.assertNotNull((Object)newBlob.getMetadata(), (String)"Created blob metadata were null");
        Assert.assertEquals((String)newBlob.getMetadata().getName(), (String)blobKey, (String)"Created blob name is different");
        blobKey = TestUtils.createRandomBlobKey("blobtest-", "");
        newBlob = this.storageStrategy.newBlob(blobKey);
        Assert.assertEquals((String)newBlob.getMetadata().getName(), (String)blobKey, (String)"Created blob name is different");
        blobKey = TestUtils.createRandomBlobKey("asd" + FS + "asd" + FS + "asdasd" + FS + "afadsf-", "");
        newBlob = this.storageStrategy.newBlob(blobKey);
        Assert.assertEquals((String)newBlob.getMetadata().getName(), (String)blobKey, (String)"Created blob name is different");
    }

    public void testWritePayloadOnFile() throws IOException {
        String blobKey = TestUtils.createRandomBlobKey("writePayload-", ".img");
        File sourceFile = TestUtils.getImageForBlobPayload();
        FilePayload filePayload = new FilePayload(sourceFile);
        this.storageStrategy.writePayloadOnFile(CONTAINER_NAME, blobKey, (Payload)filePayload);
        String blobFullPath = TARGET_CONTAINER_NAME + FS + blobKey;
        FileInputStream expectedInput = new FileInputStream(sourceFile);
        FileInputStream currentInput = new FileInputStream(blobFullPath);
        Assert.assertTrue((boolean)TestUtils.isSame(expectedInput, currentInput), (String)"Files aren't equals");
    }

    public void testWritePayloadOnFile_SourceFileDoesntExist() {
        File sourceFile = new File("asdfkjsadkfjasdlfasdflk.asdfasdfas");
        try {
            new FilePayload(sourceFile);
            Assert.fail((String)"Exception not throwed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetFileForBlobKey() {
        String fullPath = new File(TARGET_CONTAINER_NAME).getAbsolutePath() + FS;
        String blobKey = TestUtils.createRandomBlobKey("getFileForBlobKey-", ".img");
        File fileForPayload = this.storageStrategy.getFileForBlobKey(CONTAINER_NAME, blobKey);
        Assert.assertNotNull((Object)fileForPayload, (String)"Result File object is null");
        Assert.assertEquals((String)fileForPayload.getAbsolutePath(), (String)(fullPath + blobKey), (String)"Wrong file path");
        blobKey = TestUtils.createRandomBlobKey("asd" + FS + "vmad" + FS + "andsnf" + FS + "getFileForBlobKey-", ".img");
        fileForPayload = this.storageStrategy.getFileForBlobKey(CONTAINER_NAME, blobKey);
        Assert.assertEquals((String)fileForPayload.getAbsolutePath(), (String)(fullPath + blobKey), (String)"Wrong file path");
    }

    public void testGetFileForBlobKey_AbsolutePath() throws IOException {
        String absoluteBasePath = new File(this.getAbsoluteDirectory(), "basedir").getAbsolutePath() + FS;
        String absoluteContainerPath = absoluteBasePath + CONTAINER_NAME + FS;
        FilesystemStorageStrategyImpl storageStrategyAbsolute = new FilesystemStorageStrategyImpl((Provider)new Provider<BlobBuilder>(){

            public BlobBuilder get() {
                try {
                    return new BlobBuilderImpl((Crypto)new JCECrypto());
                }
                catch (Exception e) {
                    return null;
                }
            }
        }, absoluteBasePath, (FilesystemContainerNameValidator)new FilesystemContainerNameValidatorImpl(), (FilesystemBlobKeyValidator)new FilesystemBlobKeyValidatorImpl());
        TestUtils.cleanDirectoryContent(absoluteContainerPath);
        String blobKey = TestUtils.createRandomBlobKey("getFileForBlobKey-", ".img");
        File fileForPayload = storageStrategyAbsolute.getFileForBlobKey(CONTAINER_NAME, blobKey);
        Assert.assertNotNull((Object)fileForPayload, (String)"Result File object is null");
        Assert.assertEquals((String)fileForPayload.getAbsolutePath(), (String)(absoluteContainerPath + blobKey), (String)"Wrong file path");
        blobKey = TestUtils.createRandomBlobKey("asd" + FS + "vmad" + FS + "andsnf" + FS + "getFileForBlobKey-", ".img");
        fileForPayload = storageStrategyAbsolute.getFileForBlobKey(CONTAINER_NAME, blobKey);
        Assert.assertEquals((String)fileForPayload.getAbsolutePath(), (String)(absoluteContainerPath + blobKey), (String)"Wrong file path");
    }

    public void testBlobExists() throws IOException {
        String[] sourceBlobKeys;
        for (String blobKey : sourceBlobKeys = new String[]{TestUtils.createRandomBlobKey("blobExists-", ".jpg"), TestUtils.createRandomBlobKey("blobExists-", ".jpg"), TestUtils.createRandomBlobKey("afasd" + FS + "asdma" + FS + "blobExists-", ".jpg")}) {
            Assert.assertFalse((boolean)this.storageStrategy.blobExists(CONTAINER_NAME, blobKey), (String)("Blob " + blobKey + " exists"));
        }
        TestUtils.createBlobsInContainer(CONTAINER_NAME, sourceBlobKeys);
        for (String blobKey : sourceBlobKeys) {
            Assert.assertTrue((boolean)this.storageStrategy.blobExists(CONTAINER_NAME, blobKey), (String)("Blob " + blobKey + " doesn't exist"));
        }
    }

    public void testRemoveBlob() throws IOException {
        this.storageStrategy.createContainer(CONTAINER_NAME);
        Set<String> blobKeys = TestUtils.createBlobsInContainer(CONTAINER_NAME, TestUtils.createRandomBlobKey("removeBlob-", ".jpg"), TestUtils.createRandomBlobKey("removeBlob-", ".jpg"), TestUtils.createRandomBlobKey("346" + FS + "g3sx2" + FS + "removeBlob-", ".jpg"), TestUtils.createRandomBlobKey("346" + FS + "g3sx2" + FS + "removeBlob-", ".jpg"));
        HashSet<String> remainingBlobKeys = new HashSet<String>();
        for (String key : blobKeys) {
            remainingBlobKeys.add(key);
        }
        for (String blobKeyToRemove : blobKeys) {
            this.storageStrategy.removeBlob(CONTAINER_NAME, blobKeyToRemove);
            TestUtils.fileExists(blobKeyToRemove, false);
            remainingBlobKeys.remove(blobKeyToRemove);
            for (String remainingBlobKey : remainingBlobKeys) {
                TestUtils.fileExists(TARGET_CONTAINER_NAME + FS + remainingBlobKey, true);
            }
        }
    }

    public void testRemoveBlob_ContainerNotExists() {
        this.storageStrategy.removeBlob("asdasdasd", "sdfsdfsdfasd");
    }

    public void testRemoveBlob_BlobNotExists() {
        this.storageStrategy.createContainer(CONTAINER_NAME);
        this.storageStrategy.removeBlob(CONTAINER_NAME, "sdfsdfsdfasd");
    }

    public void testGetBlobKeysInsideContainer() throws IOException {
        Iterable resultList = this.storageStrategy.getBlobKeysInsideContainer(CONTAINER_NAME);
        Assert.assertNotNull((Object)resultList, (String)"Result is null");
        Assert.assertFalse((boolean)resultList.iterator().hasNext(), (String)"Blobs detected");
        this.storageStrategy.createContainer(CONTAINER_NAME);
        Set<String> createBlobKeys = TestUtils.createBlobsInContainer(CONTAINER_NAME, TestUtils.createRandomBlobKey("GetBlobKeys-", ".jpg"), TestUtils.createRandomBlobKey("GetBlobKeys-", ".jpg"), TestUtils.createRandomBlobKey("563" + FS + "g3sx2" + FS + "removeBlob-", ".jpg"), TestUtils.createRandomBlobKey("563" + FS + "g3sx2" + FS + "removeBlob-", ".jpg"));
        this.storageStrategy.getBlobKeysInsideContainer(CONTAINER_NAME);
        ArrayList retrievedBlobKeys = new ArrayList();
        resultList = this.storageStrategy.getBlobKeysInsideContainer(CONTAINER_NAME);
        Iterator containersIterator = resultList.iterator();
        while (containersIterator.hasNext()) {
            retrievedBlobKeys.add(containersIterator.next());
        }
        Assert.assertEquals((int)retrievedBlobKeys.size(), (int)createBlobKeys.size(), (String)"Different blobs number");
        for (String createdBlobKey : createBlobKeys) {
            Assert.assertTrue((boolean)retrievedBlobKeys.contains(createdBlobKey), (String)("Blob " + createdBlobKey + " not found"));
        }
    }

    public void testCountsBlob() {
        try {
            this.storageStrategy.countBlobs(CONTAINER_NAME, (ListContainerOptions)ListContainerOptions.NONE);
            Assert.fail((String)"Magically the method was implemented... Wow!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testInvalidBlobKey() {
        try {
            this.storageStrategy.newBlob(FS + "test.jpg");
            Assert.fail((String)"Wrong blob key not recognized");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidContainerName() {
        try {
            this.storageStrategy.createContainer("file" + FS + "system");
            Assert.fail((String)"Wrong container name not recognized");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private String getAbsoluteDirectory() throws IOException {
        File tempFile = File.createTempFile("prefix", "suffix");
        String tempAbsolutePath = tempFile.getParent();
        return tempAbsolutePath;
    }

    static {
        System.setProperty(LOGGING_CONFIG_KEY, LOGGING_CONFIG_VALUE);
    }
}

