/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.testng.Assert;

public class TestUtils {
    private static final String TARGET_RESOURCE_DIR = "." + File.separator + "src" + File.separator + "test" + File.separator + "resources" + File.separator;
    private static String[] imageResource = new String[]{TARGET_RESOURCE_DIR + "image1.jpg", TARGET_RESOURCE_DIR + "image2.jpg", TARGET_RESOURCE_DIR + "image3.jpg", TARGET_RESOURCE_DIR + "image4.jpg"};
    private static int imageResourceIndex = 0;
    public static final String TARGET_BASE_DIR = "." + File.separator + "target" + File.separator + "basedir" + File.separator;
    public static final Object[][] NO_INVOCATIONS = new Object[0][0];
    public static final Object[][] SINGLE_NO_ARG_INVOCATION = new Object[][]{new Object[0]};

    public static boolean isWindowsOs() {
        return System.getProperty("os.name", "").toLowerCase().contains("windows");
    }

    public static String createRandomBlobKey() {
        return TestUtils.createRandomBlobKey("", "");
    }

    public static String createRandomBlobKey(String prefix, String extension) {
        String okPrefix = null != prefix && !"".equals(prefix) ? prefix : "testkey-";
        String okExtension = null != extension && !"".equals(extension) ? extension : ".jpg";
        return okPrefix + UUID.randomUUID().toString() + okExtension;
    }

    public static Set<String> createBlobsInContainer(String containerName, String[] blobNames) throws IOException {
        HashSet<String> blobNamesCreatedInContainer = new HashSet<String>();
        for (String blobName : blobNames) {
            TestUtils.createBlobAsFile(containerName, blobName, TestUtils.getImageForBlobPayload());
            blobNamesCreatedInContainer.add(blobName);
        }
        return blobNamesCreatedInContainer;
    }

    public static void createContainerAsDirectory(String containerName) throws IOException {
        FileUtils.forceMkdir((File)new File(TARGET_BASE_DIR + containerName));
    }

    public static boolean directoryExists(String directoryFullPath) {
        File file = new File(directoryFullPath);
        boolean exists = file.exists() || file.isDirectory();
        return exists;
    }

    public static boolean directoryExists(String directoryFullPath, boolean expectedResult) {
        boolean exists = TestUtils.directoryExists(directoryFullPath);
        if (expectedResult) {
            Assert.assertTrue((boolean)exists, (String)("Directory " + directoryFullPath + " doens't exists"));
        } else {
            Assert.assertFalse((boolean)exists, (String)("Directory " + directoryFullPath + " still exists"));
        }
        return exists;
    }

    public static boolean fileExists(String fileFullName) {
        File file = new File(fileFullName);
        boolean exists = file.exists() || file.isFile();
        return exists;
    }

    public static boolean fileExists(String fileFullName, boolean expectedResult) {
        boolean exists = TestUtils.fileExists(fileFullName);
        if (expectedResult) {
            Assert.assertTrue((boolean)exists, (String)("File " + fileFullName + " doens't exists"));
        } else {
            Assert.assertFalse((boolean)exists, (String)("File " + fileFullName + " still exists"));
        }
        return exists;
    }

    public static void cleanDirectoryContent(String directoryName) throws IOException {
        File parentDirectory = new File(directoryName);
        File[] children = parentDirectory.listFiles();
        if (null != children) {
            for (File child : children) {
                FileUtils.forceDelete((File)child);
            }
        }
    }

    public static void createBlobAsFile(String containerName, String blobKey, File source) throws IOException {
        String filePath = blobKey.startsWith("\\") ? containerName + blobKey : containerName + File.separator + blobKey;
        FileUtils.copyFile((File)source, (File)new File(TARGET_BASE_DIR + filePath));
    }

    public static File getImageForBlobPayload() {
        String fileName = imageResource[imageResourceIndex++];
        if (imageResourceIndex >= imageResource.length) {
            imageResourceIndex = 0;
        }
        return new File(fileName);
    }

    /*
     * Exception decompiling
     */
    public static boolean isSame(InputStream input1, InputStream input2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

