/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import com.google.common.base.Preconditions;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.MediaType;

public class SCSIDevice
extends Device {
    private static final int bus = 0;
    private final int unit;

    public SCSIDevice(String driveUuid, MediaType mediaType, int unit) {
        super(driveUuid, mediaType);
        Preconditions.checkArgument((unit >= 0 && unit < 8 ? 1 : 0) != 0, (Object)"unit must be between 0 and 7");
        this.unit = unit;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + 0;
        result = 31 * result + this.unit;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SCSIDevice other = (SCSIDevice)obj;
        if (false) {
            return false;
        }
        return this.unit == other.unit;
    }

    public int getBus() {
        return 0;
    }

    public int getUnit() {
        return this.unit;
    }

    @Override
    public String getId() {
        return String.format("scsi:%d:%d", 0, this.unit);
    }

    @Override
    public String toString() {
        return "[id=" + this.getId() + ", driveUuid=" + this.driveUuid + ", mediaType=" + (Object)((Object)this.mediaType) + "]";
    }

    public static class Builder
    extends Device.Builder {
        private final int unit;

        public Builder(int unit) {
            this.unit = unit;
        }

        @Override
        public Device build() {
            return new SCSIDevice(this.uuid, this.mediaType, this.unit);
        }
    }
}

