/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.handlers;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.elasticstack.handlers.ElasticStackErrorHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ElasticStackErrorHandlerTest {
    @Test
    public void test400MakesIllegalArgumentException() {
        this.assertCodeMakes("GET", URI.create("https://elasticstack.com/foo"), 400, "", "Bad Request", IllegalArgumentException.class);
    }

    @Test
    public void test400MakesResourceNotFoundExceptionOnInfo() {
        this.assertCodeMakes("GET", URI.create("https://elasticstack.com/foo/info"), 400, "", "", ResourceNotFoundException.class);
    }

    @Test
    public void test400MakesResourceNotFoundExceptionOnMessageNotFound() {
        this.assertCodeMakes("GET", URI.create("https://elasticstack.com/foo"), 400, "", "errors:system Drive 8f9b42b1-26de-49ad-a3fd-d4fa06524339 could not be found. Please re-validate your entry.", ResourceNotFoundException.class);
    }

    @Test
    public void test401MakesAuthorizationException() {
        this.assertCodeMakes("GET", URI.create("https://elasticstack.com/foo"), 401, "", "Unauthorized", AuthorizationException.class);
    }

    @Test
    public void test404MakesResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://elasticstack.com/foo"), 404, "", "Not Found", ResourceNotFoundException.class);
    }

    @Test
    public void test405MakesIllegalArgumentException() {
        this.assertCodeMakes("GET", URI.create("https://elasticstack.com/foo"), 405, "", "Method Not Allowed", IllegalArgumentException.class);
    }

    @Test
    public void test409MakesIllegalStateException() {
        this.assertCodeMakes("GET", URI.create("https://elasticstack.com/foo"), 409, "", "Conflict", IllegalStateException.class);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String content, Class<? extends Exception> expected) {
        this.assertCodeMakes(method, uri, statusCode, message, "text/xml", content, expected);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected) {
        ElasticStackErrorHandler function = (ElasticStackErrorHandler)Guice.createInjector((Module[])new Module[0]).getInstance(ElasticStackErrorHandler.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = new HttpRequest(method, uri);
        HttpResponse response = new HttpResponse(statusCode, message, (Payload)Payloads.newInputStreamPayload((InputStream)Strings2.toInputStream((String)content)));
        response.getPayload().getContentMetadata().setContentType(contentType);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(ElasticStackErrorHandlerTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }
}

