/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.jclouds.elasticstack.ElasticStackAsyncClient;
import org.jclouds.elasticstack.ElasticStackClient;
import org.jclouds.elasticstack.binders.BindServerToPlainTextStringTest;
import org.jclouds.elasticstack.domain.CreateDriveRequest;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.DriveData;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.functions.KeyValuesDelimitedByBlankLinesToDriveInfo;
import org.jclouds.elasticstack.functions.KeyValuesDelimitedByBlankLinesToServerInfo;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet;
import org.jclouds.elasticstack.functions.ReturnPayload;
import org.jclouds.elasticstack.functions.SplitNewlines;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.rest.RestClientTest;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.jclouds.rest.functions.MapHttp4xxCodesToExceptions;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ElasticStackAsyncClientTest")
public class ElasticStackAsyncClientTest
extends RestClientTest<ElasticStackAsyncClient> {
    public void testListServers() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("listServers", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.elasticstack.com/servers/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.elasticstack.com/servers/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic Zm9vOmJhcg==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListServerInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("listServerInfo", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.elasticstack.com/servers/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetServerInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("getServerInfo", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.elasticstack.com/servers/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateAndStartServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("createAndStartServer", Server.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{BindServerToPlainTextStringTest.SERVER});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/servers/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, BindServerToPlainTextStringTest.CREATED_SERVER, "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("createServer", Server.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{BindServerToPlainTextStringTest.SERVER});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/servers/create/stopped HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, BindServerToPlainTextStringTest.CREATED_SERVER, "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testSetServerConfiguration() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("setServerConfiguration", String.class, Server.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"100", BindServerToPlainTextStringTest.SERVER});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/servers/100/set HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, BindServerToPlainTextStringTest.CREATED_SERVER, "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("destroyServer", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/servers/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testStartServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("startServer", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/servers/uuid/start HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testStopServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("stopServer", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/servers/uuid/stop HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testShutdownServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("shutdownServer", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/servers/uuid/shutdown HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testResetServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("resetServer", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/servers/uuid/reset HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListDrives() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("listDrives", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.elasticstack.com/drives/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.elasticstack.com/drives/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic Zm9vOmJhcg==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListDriveInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("listDriveInfo", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.elasticstack.com/drives/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetDriveInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("getDriveInfo", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.elasticstack.com/drives/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateDrive() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("createDrive", Drive.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{new CreateDriveRequest.Builder().name("foo").size(10000L).build()});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/drives/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name foo\nsize 10000", "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testSetDriveData() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("setDriveData", String.class, DriveData.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"100", new DriveData.Builder().name("foo").size(10000L).tags((Iterable)ImmutableList.of((Object)"production", (Object)"candy")).build()});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/drives/100/set HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name foo\nsize 10000\ntags production candy", "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyDrive() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("destroyDrive", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/drives/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testImageDrive() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("imageDrive", String.class, String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"100", "200"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/drives/200/image/100 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testImageDriveWithConversion() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("imageDrive", String.class, String.class, ImageConversionType.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"100", "200", ImageConversionType.GUNZIP});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/drives/200/image/100/gunzip HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testReadDrive() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("readDrive", String.class, Long.TYPE, Long.TYPE);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"100", 1024, 2048});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/drives/100/read/1024/2048 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/octet-stream\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReturnPayload.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testWriteDrive() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("writeDrive", String.class, Payload.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"100", Payloads.newStringPayload((String)"foo")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/drives/100/write HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "foo", "application/octet-stream", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testWriteDriveOffset() throws SecurityException, NoSuchMethodException, IOException {
        Method method = ElasticStackAsyncClient.class.getMethod("writeDrive", String.class, Payload.class, Long.TYPE);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"100", Payloads.newStringPayload((String)"foo"), 2048});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.elasticstack.com/drives/100/write/2048 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "foo", "application/octet-stream", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), BasicAuthentication.class);
    }

    protected TypeLiteral<RestAnnotationProcessor<ElasticStackAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<ElasticStackAsyncClient>>(){};
    }

    public RestContextSpec<ElasticStackClient, ElasticStackAsyncClient> createContextSpec() {
        Properties props = new Properties();
        props.setProperty("elasticstack.endpoint", "https://api.elasticstack.com");
        return new RestContextFactory().createContextSpec("elasticstack", "foo", "bar", props);
    }
}

