/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.binders;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.jclouds.elasticstack.binders.BindServerToPlainTextString;
import org.jclouds.elasticstack.domain.IDEDevice;
import org.jclouds.elasticstack.domain.Model;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.VNC;
import org.jclouds.elasticstack.functions.ServerToMap;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindServerToPlainTextStringTest {
    public static String CREATED_SERVER;
    public static final Server SERVER;
    private Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith(ApiVersion.class).to("1.0");
            this.bind((TypeLiteral)new TypeLiteral<Function<Server, Map<String, String>>>(){}).to(ServerToMap.class);
        }
    }});

    public void testSimple() throws IOException {
        HttpRequest request = new HttpRequest("POST", URI.create("https://host/drives/create"));
        ((BindServerToPlainTextString)this.i.getInstance(BindServerToPlainTextString.class)).bindToRequest(request, (Object)SERVER);
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"text/plain");
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)CREATED_SERVER);
    }

    static {
        try {
            CREATED_SERVER = Strings2.toStringAndClose((InputStream)BindServerToPlainTextStringTest.class.getResourceAsStream("/create_server.txt"));
        }
        catch (IOException e) {
            CREATED_SERVER = null;
        }
        SERVER = new Server.Builder().name("TestServer").cpu(2000).mem(1024).devices((Map)ImmutableMap.of((Object)"ide:0:0", (Object)new IDEDevice.Builder(0, 0).uuid("08c92dd5-70a0-4f51-83d2-835919d254df").build())).bootDeviceIds((Iterable)ImmutableSet.of((Object)"ide:0:0")).nics((Iterable)ImmutableSet.of((Object)new NIC.Builder().model(Model.E1000).build())).vnc(new VNC(null, "XXXXXXXX", false)).build();
    }
}

