/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.elasticstack.ElasticStackClient;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.domain.ServerStatus;
import org.jclouds.elasticstack.domain.WellKnownImage;
import org.jclouds.elasticstack.util.Servers;
import org.jclouds.location.suppliers.JustProvider;
import org.jclouds.logging.Logger;

@Singleton
public class ElasticStackComputeServiceAdapter
implements ComputeServiceAdapter<ServerInfo, Hardware, DriveInfo, Location> {
    private final ElasticStackClient client;
    private final Predicate<DriveInfo> driveNotClaimed;
    private final Map<String, WellKnownImage> preinstalledImages;
    private final LoadingCache<String, DriveInfo> cache;
    private final JustProvider locationSupplier;
    private final String defaultVncPassword;
    private final ExecutorService executor;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Inject
    public ElasticStackComputeServiceAdapter(ElasticStackClient client, Predicate<DriveInfo> driveNotClaimed, JustProvider locationSupplier, Map<String, WellKnownImage> preinstalledImages, LoadingCache<String, DriveInfo> cache, @Named(value="jclouds.elasticstack.vnc-password") String defaultVncPassword, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.client = (ElasticStackClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.driveNotClaimed = (Predicate)Preconditions.checkNotNull(driveNotClaimed, (Object)"driveNotClaimed");
        this.locationSupplier = (JustProvider)Preconditions.checkNotNull((Object)locationSupplier, (Object)"locationSupplier");
        this.preinstalledImages = (Map)Preconditions.checkNotNull(preinstalledImages, (Object)"preinstalledImages");
        this.cache = (LoadingCache)Preconditions.checkNotNull(cache, (Object)"cache");
        this.defaultVncPassword = (String)Preconditions.checkNotNull((Object)defaultVncPassword, (Object)"defaultVncPassword");
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<ServerInfo> createNodeWithGroupEncodedIntoName(String tag, String name, Template template) {
        long bootSize = (long)(((Volume)template.getHardware().getVolumes().get(0)).getSize().floatValue() * 1024.0f * 1024.0f * 1024.0f);
        this.logger.debug(">> creating boot drive bytes(%d)", new Object[]{bootSize});
        DriveInfo drive = this.client.createDrive(new Drive.Builder().name(template.getImage().getId()).size(bootSize).build());
        this.logger.debug("<< drive(%s)", new Object[]{drive.getUuid()});
        this.logger.debug(">> imaging boot drive source(%s)", new Object[]{template.getImage().getId()});
        this.client.imageDrive(template.getImage().getId(), drive.getUuid(), ImageConversionType.GUNZIP);
        boolean success = this.driveNotClaimed.apply((Object)drive);
        this.logger.debug("<< imaged (%s)", new Object[]{success});
        if (!success) {
            this.client.destroyDrive(drive.getUuid());
            throw new IllegalStateException("could not image drive in time!");
        }
        Server toCreate = Servers.small(name, drive.getUuid(), this.defaultVncPassword).mem(template.getHardware().getRam()).cpu((int)((Processor)template.getHardware().getProcessors().get(0)).getSpeed()).build();
        ServerInfo from = this.client.createServer(toCreate);
        this.client.startServer(from.getUuid());
        from = this.client.getServerInfo(from.getUuid());
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)from, from.getUuid(), LoginCredentials.builder().password(this.defaultVncPassword).build());
    }

    public Iterable<Hardware> listHardwareProfiles() {
        ImmutableSet.Builder hardware = ImmutableSet.builder();
        for (double cpu : new double[]{1000.0, 5000.0, 10000.0, 20000.0}) {
            for (int ram : new int[]{512, 1024, 2048, 4096, 8192}) {
                final float size = (float)cpu / 1000.0f;
                String id = String.format("cpu=%f,ram=%s,disk=%f", cpu, ram, Float.valueOf(size));
                hardware.add((Object)new HardwareBuilder().supportsImage((Predicate)new Predicate<Image>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean apply(Image input) {
                        String toParse = (String)input.getUserMetadata().get("size");
                        if (toParse == null) return false;
                        Float f = new Float(toParse);
                        if (!(f.floatValue() <= size)) return false;
                        return true;
                    }

                    public String toString() {
                        return "sizeLessThanOrEqual(" + size + ")";
                    }
                }).ids(id).ram(ram).processors((Iterable)ImmutableList.of((Object)new Processor(1.0, cpu))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(size), true, true))).build());
            }
        }
        return hardware.build();
    }

    public Iterable<DriveInfo> listImages() {
        Iterable drives = FutureIterables.transformParallel(this.preinstalledImages.keySet(), (Function)new Function<String, Future<DriveInfo>>(){

            public Future<DriveInfo> apply(String input) {
                try {
                    return Futures.immediateFuture((Object)ElasticStackComputeServiceAdapter.this.cache.getUnchecked((Object)input));
                }
                catch (CacheLoader.InvalidCacheLoadException e) {
                    ElasticStackComputeServiceAdapter.this.logger.debug("drive %s not found", new Object[]{input});
                }
                catch (UncheckedExecutionException e) {
                    ElasticStackComputeServiceAdapter.this.logger.warn((Throwable)e, "error finding drive %s: %s", new Object[]{input, e.getMessage()});
                }
                return Futures.immediateFuture(null);
            }

            public String toString() {
                return "seedDriveCache()";
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)"drives");
        return Iterables.filter((Iterable)drives, (Predicate)Predicates.notNull());
    }

    public Iterable<ServerInfo> listNodes() {
        return this.client.listServerInfo();
    }

    public Iterable<Location> listLocations() {
        return this.locationSupplier.get();
    }

    public ServerInfo getNode(String id) {
        return this.client.getServerInfo(id);
    }

    public void destroyNode(String id) {
        ServerInfo server = this.getNode(id);
        if (server != null) {
            if (server.getStatus() != ServerStatus.STOPPED) {
                this.client.stopServer(id);
            }
            this.client.destroyServer(id);
            for (Device dev : server.getDevices().values()) {
                this.client.destroyDrive(dev.getDriveUuid());
            }
        }
    }

    public void rebootNode(String id) {
        this.client.resetServer(id);
    }

    public void resumeNode(String id) {
        this.client.startServer(id);
    }

    public void suspendNode(String id) {
        this.client.stopServer(id);
    }
}

