/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.domain.Credentials;
import org.jclouds.elasticstack.ElasticStackAsyncClient;
import org.jclouds.elasticstack.ElasticStackClient;
import org.jclouds.elasticstack.domain.ClaimType;
import org.jclouds.elasticstack.domain.CreateDriveRequest;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.DriveData;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.DriveStatus;
import org.jclouds.elasticstack.domain.IDEDevice;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.jclouds.elasticstack.domain.Model;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.domain.ServerStatus;
import org.jclouds.elasticstack.predicates.DriveClaimed;
import org.jclouds.elasticstack.util.Servers;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.InetSocketAddressConnect;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.RestContext;
import org.jclouds.ssh.SshClient;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class ElasticStackClientLiveTest {
    protected long driveSize = 0x40000000L;
    protected int maxDriveImageTime = 360;
    protected String vncPassword = "Il0veVNC";
    protected ElasticStackClient client;
    protected RestContext<ElasticStackClient, ElasticStackAsyncClient> context;
    protected Predicate<IPSocket> socketTester;
    protected String bootDrive = "38df0986-4d85-4b76-b502-3878ffc80161";
    protected String provider = "elasticstack";
    protected String identity;
    protected String credential;
    protected String endpoint;
    protected String apiversion;
    protected Predicate<DriveInfo> driveNotClaimed;
    protected String prefix = System.getProperty("user.name") + ".test";
    protected DriveInfo drive;
    protected ServerInfo server;
    private DriveInfo drive2;
    private DriveInfo drive3;

    protected void setupCredentials() {
        this.identity = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".identity"), (Object)("test." + this.provider + ".identity"));
        this.credential = System.getProperty("test." + this.provider + ".credential");
        this.endpoint = System.getProperty("test." + this.provider + ".endpoint");
        this.apiversion = System.getProperty("test." + this.provider + ".apiversion");
    }

    protected Properties setupProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.trust-all-certs", "true");
        overrides.setProperty("jclouds.relax-hostname", "true");
        overrides.setProperty(this.provider + ".identity", this.identity);
        if (this.credential != null) {
            overrides.setProperty(this.provider + ".credential", this.credential);
        }
        if (this.endpoint != null) {
            overrides.setProperty(this.provider + ".endpoint", this.endpoint);
        }
        if (this.apiversion != null) {
            overrides.setProperty(this.provider + ".apiversion", this.apiversion);
        }
        return overrides;
    }

    @BeforeGroups(groups={"live"})
    public void setupClient() {
        this.setupCredentials();
        Properties overrides = this.setupProperties();
        this.context = new ComputeServiceContextFactory().createContext(this.provider, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule()), overrides).getProviderSpecificContext();
        this.client = (ElasticStackClient)this.context.getApi();
        this.driveNotClaimed = new RetryablePredicate(Predicates.not((Predicate)new DriveClaimed(this.client)), (long)this.maxDriveImageTime, 1L, TimeUnit.SECONDS);
        this.socketTester = new RetryablePredicate((Predicate)new InetSocketAddressConnect(), (long)this.maxDriveImageTime, 1L, TimeUnit.SECONDS);
    }

    @Test
    public void testListServers() throws Exception {
        Set servers = this.client.listServers();
        Assert.assertNotNull((Object)servers);
    }

    @Test
    public void testListServerInfo() throws Exception {
        Set servers = this.client.listServerInfo();
        Assert.assertNotNull((Object)servers);
    }

    @Test
    public void testGetServer() throws Exception {
        for (String serverUUID : this.client.listServers()) {
            assert (!"".equals(serverUUID));
            Assert.assertNotNull((Object)this.client.getServerInfo(serverUUID));
        }
    }

    @Test
    public void testListDrives() throws Exception {
        Set drives = this.client.listDrives();
        Assert.assertNotNull((Object)drives);
    }

    @Test
    public void testListDriveInfo() throws Exception {
        Set drives = this.client.listDriveInfo();
        Assert.assertNotNull((Object)drives);
    }

    @Test
    public void testGetDrive() throws Exception {
        for (String driveUUID : this.client.listDrives()) {
            assert (!"".equals(driveUUID)) : driveUUID;
            assert (this.client.getDriveInfo(driveUUID) != null) : driveUUID;
        }
    }

    @Test
    public void testCreateDrive() throws Exception {
        this.drive = this.client.createDrive((Drive)new CreateDriveRequest.Builder().name(this.prefix).size(this.driveSize).build());
        this.checkCreatedDrive();
        DriveInfo newInfo = this.client.getDriveInfo(this.drive.getUuid());
        this.checkDriveMatchesGet(newInfo);
    }

    protected void checkDriveMatchesGet(DriveInfo newInfo) {
        Assert.assertEquals((String)newInfo.getUuid(), (String)this.drive.getUuid());
    }

    protected void checkCreatedDrive() {
        Assert.assertNotNull((Object)this.drive.getUuid());
        Assert.assertNotNull((Object)this.drive.getUser());
        Assert.assertEquals((String)this.drive.getName(), (String)this.prefix);
        Assert.assertEquals((long)this.drive.getSize(), (long)this.driveSize);
        Assert.assertEquals((Object)this.drive.getStatus(), (Object)DriveStatus.ACTIVE);
        Assert.assertEquals((String)this.drive.getEncryptionCipher(), (String)"aes-xts-plain");
    }

    @Test(dependsOnMethods={"testCreateDrive"})
    public void testSetDriveData() throws Exception {
        DriveInfo drive2 = this.client.setDriveData(this.drive.getUuid(), new DriveData.Builder().claimType(ClaimType.SHARED).name("rediculous").readers((Iterable)ImmutableSet.of((Object)"ffffffff-ffff-ffff-ffff-ffffffffffff")).tags((Iterable)ImmutableSet.of((Object)"networking", (Object)"security", (Object)"gateway")).userMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar")).build());
        Assert.assertNotNull((Object)drive2.getUuid(), (String)this.drive.getUuid());
        Assert.assertEquals((String)drive2.getName(), (String)"rediculous");
        Assert.assertEquals((Object)drive2.getClaimType(), (Object)ClaimType.SHARED);
        Assert.assertEquals((Set)drive2.getReaders(), (Set)ImmutableSet.of((Object)"ffffffff-ffff-ffff-ffff-ffffffffffff"));
        Assert.assertEquals((Set)drive2.getTags(), (Set)ImmutableSet.of((Object)"networking", (Object)"security", (Object)"gateway"));
        Assert.assertEquals((Map)drive2.getUserMetadata(), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        this.drive = drive2;
    }

    @Test(dependsOnMethods={"testSetDriveData"})
    public void testCreateAndStartServer() throws Exception {
        Logger.getAnonymousLogger().info("preparing drive");
        this.prepareDrive();
        Server serverRequest = Servers.small((String)this.prefix, (String)this.drive.getUuid(), (String)this.vncPassword).build();
        Logger.getAnonymousLogger().info("starting server");
        this.server = this.client.createServer(serverRequest);
        this.client.startServer(this.server.getUuid());
        this.server = this.client.getServerInfo(this.server.getUuid());
        this.checkStartedServer();
        ServerInfo newInfo = this.client.getServerInfo(this.server.getUuid());
        this.checkServerMatchesGet((Server)newInfo);
    }

    protected void checkServerMatchesGet(Server newInfo) {
        Assert.assertEquals((String)newInfo.getUuid(), (String)this.server.getUuid());
    }

    protected void checkStartedServer() {
        System.out.println(new Gson().toJson((Object)this.server));
        Assert.assertNotNull((Object)this.server.getUuid());
        Assert.assertNotNull((Object)this.server.getUser());
        Assert.assertEquals((String)this.server.getName(), (String)this.prefix);
        Assert.assertEquals((boolean)this.server.isPersistent(), (boolean)true);
        Assert.assertEquals((Map)this.server.getDevices(), (Map)ImmutableMap.of((Object)"ide:0:0", (Object)new IDEDevice.Builder(0, 0).uuid(this.drive.getUuid()).build()));
        Assert.assertEquals((Set)this.server.getBootDeviceIds(), (Set)ImmutableSet.of((Object)"ide:0:0"));
        Assert.assertEquals((String)((NIC)this.server.getNics().get(0)).getDhcp(), (String)this.server.getVnc().getIp());
        Assert.assertEquals((Object)((NIC)this.server.getNics().get(0)).getModel(), (Object)Model.E1000);
        Assert.assertEquals((Object)this.server.getStatus(), (Object)ServerStatus.ACTIVE);
    }

    @Test(dependsOnMethods={"testCreateAndStartServer"})
    public void testConnectivity() throws Exception {
        IPSocket vncsocket = new IPSocket(this.server.getVnc().getIp(), 5900);
        Logger.getAnonymousLogger().info("awaiting vnc: " + vncsocket);
        assert (this.socketTester.apply((Object)vncsocket)) : this.server;
        IPSocket sshsocket = new IPSocket(((NIC)this.server.getNics().get(0)).getDhcp(), 22);
        Logger.getAnonymousLogger().info("awaiting ssh: " + sshsocket);
        assert (this.socketTester.apply((Object)sshsocket)) : this.server;
        this.doConnectViaSsh((Server)this.server, this.getSshCredentials((Server)this.server));
    }

    @Test(dependsOnMethods={"testConnectivity"})
    public void testLifeCycle() throws Exception {
        this.client.stopServer(this.server.getUuid());
        Assert.assertEquals((Object)this.client.getServerInfo(this.server.getUuid()).getStatus(), (Object)ServerStatus.STOPPED);
        this.client.startServer(this.server.getUuid());
        Assert.assertEquals((Object)this.client.getServerInfo(this.server.getUuid()).getStatus(), (Object)ServerStatus.ACTIVE);
        this.client.resetServer(this.server.getUuid());
        Assert.assertEquals((Object)this.client.getServerInfo(this.server.getUuid()).getStatus(), (Object)ServerStatus.ACTIVE);
        this.client.shutdownServer(this.server.getUuid());
        assert (this.client.getServerInfo(this.server.getUuid()).getStatus() == ServerStatus.ACTIVE || this.client.getServerInfo(this.server.getUuid()).getStatus() == ServerStatus.STOPPED);
    }

    @Test(dependsOnMethods={"testLifeCycle"})
    public void testSetServerConfiguration() throws Exception {
        this.client.stopServer(this.server.getUuid());
        Assert.assertEquals((Object)this.client.getServerInfo(this.server.getUuid()).getStatus(), (Object)ServerStatus.STOPPED);
        ServerInfo server2 = this.client.setServerConfiguration(this.server.getUuid(), Server.Builder.fromServer((Server)this.server).name("rediculous").tags((Iterable)ImmutableSet.of((Object)"networking", (Object)"security", (Object)"gateway")).userMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar")).build());
        Assert.assertNotNull((Object)server2.getUuid(), (String)this.server.getUuid());
        Assert.assertEquals((String)server2.getName(), (String)"rediculous");
        this.checkTagsAndMetadata(server2);
        this.server = server2;
    }

    protected void checkTagsAndMetadata(ServerInfo server2) {
        Assert.assertEquals((Set)server2.getTags(), (Set)ImmutableSet.of((Object)"networking", (Object)"security", (Object)"gateway"));
        Assert.assertEquals((Map)server2.getUserMetadata(), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
    }

    @Test(dependsOnMethods={"testSetServerConfiguration"})
    public void testDestroyServer() throws Exception {
        this.client.destroyServer(this.server.getUuid());
        Assert.assertEquals((Object)this.client.getServerInfo(this.server.getUuid()), null);
    }

    @Test(dependsOnMethods={"testDestroyServer"})
    public void testDestroyDrive() throws Exception {
        this.client.destroyDrive(this.drive.getUuid());
        Assert.assertEquals((Object)this.client.getDriveInfo(this.drive.getUuid()), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnectViaSsh(Server server, Credentials creds) throws IOException {
        SshClient ssh = ((SshClient.Factory)Guice.createInjector((Module[])new Module[]{new SshjSshClientModule()}).getInstance(SshClient.Factory.class)).create(new IPSocket(server.getVnc().getIp(), 22), creds);
        try {
            ssh.connect();
            ExecResponse hello = ssh.exec("echo hello");
            Assert.assertEquals((String)hello.getOutput().trim(), (String)"hello");
            System.err.println(ssh.exec("df -k").getOutput());
            System.err.println(ssh.exec("mount").getOutput());
            System.err.println(ssh.exec("uname -a").getOutput());
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        try {
            this.client.destroyServer(this.server.getUuid());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.client.destroyDrive(this.drive.getUuid());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.context != null) {
            this.context.close();
        }
    }

    public void testWeCanReadAndWriteToDrive() throws IOException {
        this.drive2 = this.client.createDrive((Drive)new CreateDriveRequest.Builder().name(this.prefix + "2").size(0x100000L).build());
        this.client.writeDrive(this.drive2.getUuid(), (Payload)Payloads.newStringPayload((String)"foo"));
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)this.client.readDrive(this.drive2.getUuid(), 0L, 3L).getInput()), (String)"foo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testWeCanReadAndWriteToDrive"})
    public void testWeCopyADriveContentsViaGzip() throws IOException {
        try {
            this.drive3 = this.client.createDrive((Drive)new CreateDriveRequest.Builder().name(this.prefix + "3").size(0x100000L).build());
            System.err.println("before image; drive 2" + this.client.getDriveInfo(this.drive2.getUuid()));
            System.err.println("before image; drive 3" + this.client.getDriveInfo(this.drive3.getUuid()));
            this.client.imageDrive(this.drive2.getUuid(), this.drive3.getUuid());
            assert (this.driveNotClaimed.apply((Object)this.drive3)) : this.client.getDriveInfo(this.drive3.getUuid());
            assert (this.driveNotClaimed.apply((Object)this.drive2)) : this.client.getDriveInfo(this.drive2.getUuid());
            System.err.println("after image; drive 2" + this.client.getDriveInfo(this.drive2.getUuid()));
            System.err.println("after image; drive 3" + this.client.getDriveInfo(this.drive3.getUuid()));
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)this.client.readDrive(this.drive3.getUuid(), 0L, 3L).getInput()), (String)"foo");
        }
        finally {
            this.client.destroyDrive(this.drive2.getUuid());
            this.client.destroyDrive(this.drive3.getUuid());
        }
    }

    protected Credentials getSshCredentials(Server server) {
        return new Credentials("toor", server.getVnc().getPassword());
    }

    protected void prepareDrive() {
        System.err.println("before prepare" + this.client.getDriveInfo(this.drive.getUuid()));
        this.client.imageDrive(this.bootDrive, this.drive.getUuid(), ImageConversionType.GUNZIP);
        assert (this.driveNotClaimed.apply((Object)this.drive)) : this.client.getDriveInfo(this.drive.getUuid());
        System.err.println("after prepare" + this.client.getDriveInfo(this.drive.getUuid()));
    }
}

