/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.elasticstack.domain.Server;

@Singleton
public class ServerToMap
implements Function<Server, Map<String, String>> {
    public Map<String, String> apply(Server from) {
        Preconditions.checkNotNull((Object)from, (Object)"server");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"name", (Object)from.getName());
        builder.put((Object)"cpu", (Object)(from.getCpu() + ""));
        if (from.getSmp() != null) {
            builder.put((Object)"smp", (Object)(from.getSmp() + ""));
        } else {
            builder.put((Object)"smp", (Object)"auto");
        }
        builder.put((Object)"mem", (Object)(from.getMem() + ""));
        builder.put((Object)"persistent", (Object)(from.isPersistent() + ""));
        if (from.getBootDeviceIds().size() != 0) {
            builder.put((Object)"boot", (Object)Joiner.on((char)' ').join(from.getBootDeviceIds()));
        }
        for (Map.Entry<String, Device> entry : from.getDevices().entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getDriveUuid());
            builder.put((Object)(entry.getKey() + ":media"), (Object)entry.getValue().getMediaType().toString());
        }
        int nicId = 0;
        for (NIC nIC : from.getNics()) {
            builder.put((Object)("nic:" + nicId + ":model"), (Object)nIC.getModel().toString());
            if (nIC.getDhcp() != null) {
                builder.put((Object)("nic:" + nicId + ":dhcp"), (Object)nIC.getDhcp());
            }
            if (nIC.getVlan() != null) {
                builder.put((Object)("nic:" + nicId + ":vlan"), (Object)nIC.getVlan());
            }
            if (nIC.getMac() != null) {
                builder.put((Object)("nic:" + nicId + ":mac"), (Object)nIC.getMac());
            }
            ++nicId;
        }
        builder.put((Object)"vnc:ip", (Object)(from.getVnc().getIp() == null ? "auto" : from.getVnc().getIp()));
        if (from.getVnc().getPassword() != null) {
            builder.put((Object)"vnc:password", (Object)from.getVnc().getPassword());
        }
        if (from.getVnc().isTls()) {
            builder.put((Object)"vnc:tls", (Object)"on");
        }
        if (from.getTags().size() != 0) {
            builder.put((Object)"tags", (Object)Joiner.on((char)' ').join(from.getTags()));
        }
        for (Map.Entry entry : from.getUserMetadata().entrySet()) {
            builder.put((Object)("user:" + (String)entry.getKey()), entry.getValue());
        }
        return builder.build();
    }
}

