/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.jclouds.elasticstack.domain.DriveMetrics;
import org.jclouds.elasticstack.domain.IDEDevice;
import org.jclouds.elasticstack.domain.MediaType;
import org.jclouds.elasticstack.domain.Model;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.domain.ServerMetrics;
import org.jclouds.elasticstack.domain.ServerStatus;
import org.jclouds.elasticstack.domain.VNC;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToListOfMaps;
import org.jclouds.elasticstack.functions.MapToDevices;
import org.jclouds.elasticstack.functions.MapToDriveMetrics;
import org.jclouds.elasticstack.functions.MapToNICs;
import org.jclouds.elasticstack.functions.MapToServerInfo;
import org.jclouds.elasticstack.functions.MapToServerMetrics;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class MapToServerInfoTest {
    public static ServerInfo ONE = new ServerInfo.Builder().persistent(true).uuid("f8bee9cd-8e4b-4a05-8593-1314e3bfe49b").cpu(2000).bootDeviceIds((Iterable)ImmutableSet.of((Object)"ide:0:0")).smp(Integer.valueOf(1)).mem(1024).status(ServerStatus.ACTIVE).started(new Date(1291493868L)).user("2f6244eb-50bc-4403-847e-f03cc3706a1f").name("jo").vnc(new VNC("46.20.114.124", "HfHzVmLT", false)).nics((Iterable)ImmutableSet.of((Object)new NIC.Builder().model(Model.E1000).dhcp("46.20.114.124").block((Iterable)ImmutableList.of((Object)"tcp/43594", (Object)"tcp/5902", (Object)"udp/5060", (Object)"tcp/5900", (Object)"tcp/5901", (Object)"tcp/21", (Object)"tcp/22", (Object)"tcp/23", (Object)"tcp/25", (Object)"tcp/110", (Object)"tcp/143", (Object)"tcp/43595", (Object[])new String[0])).build())).devices((Map)ImmutableMap.of((Object)"ide:0:0", (Object)new IDEDevice.Builder(0, 0).uuid("4af85ed3-0caa-4736-8a26-a33d7de0a122").build())).metrics(new ServerMetrics.Builder().tx(2550L).txPackets(31L).rx(455530L).rxPackets(7583L).driveMetrics((Map)ImmutableMap.of((Object)"ide:0:0", (Object)new DriveMetrics.Builder().readRequests(11154L).readBytes(45686784L).writeRequests(3698L).writeBytes(15147008L).build())).build()).build();
    public static ServerInfo TWO = new ServerInfo.Builder().status(ServerStatus.STOPPED).name("Demo").mem(1024).cpu(2000).persistent(true).uuid("0f962616-2071-4173-be79-7dd084271edf").bootDeviceIds((Iterable)ImmutableSet.of((Object)"ide:0:0")).user("2f6244eb-50bc-4403-847e-f03cc3706a1f").vnc(new VNC("auto", "HWbjvrg2", false)).nics((Iterable)ImmutableSet.of((Object)new NIC.Builder().model(Model.E1000).dhcp("auto").build())).devices((Map)ImmutableMap.of((Object)"ide:0:0", (Object)new IDEDevice.Builder(0, 0).uuid("853bb98a-4fff-4c2f-a265-97c363f19ea5").mediaType(MediaType.CDROM).build())).metrics(new ServerMetrics.Builder().driveMetrics((Map)ImmutableMap.of((Object)"ide:0:0", (Object)new DriveMetrics.Builder().build())).build()).build();
    private static final MapToServerInfo MAP_TO_DRIVE = new MapToServerInfo((Function)new MapToDevices((Function)new MapToDevices.DeviceToId()), (Function)new MapToServerMetrics((Function)new MapToDriveMetrics()), (Function)new MapToNICs());
    public static ServerInfo NEW = new ServerInfo.Builder().persistent(true).uuid("bd98615a-6f74-4d63-ad1e-b13338b9356a").cpu(1000).bootDeviceIds((Iterable)ImmutableSet.of((Object)"ide:0:0")).smp(Integer.valueOf(1)).mem(512).status(ServerStatus.ACTIVE).started(new Date(1292695612L)).user("2f6244eb-50bc-4403-847e-f03cc3706a1f").name("adriancole.test").vnc(new VNC("83.222.249.221", "XXXXXXXX", false)).nics((Iterable)ImmutableSet.of((Object)new NIC.Builder().model(Model.E1000).block((Iterable)ImmutableList.of((Object)"tcp/43594", (Object)"tcp/5902", (Object)"udp/5060", (Object)"tcp/5900", (Object)"tcp/5901", (Object)"tcp/21", (Object)"tcp/22", (Object)"tcp/23", (Object)"tcp/25", (Object)"tcp/110", (Object)"tcp/143", (Object)"tcp/43595", (Object[])new String[0])).build())).devices((Map)ImmutableMap.of((Object)"ide:0:0", (Object)new IDEDevice.Builder(0, 0).uuid("403c9a86-0aab-4e47-aa95-e9768021c4c1").build())).metrics(new ServerMetrics.Builder().driveMetrics((Map)ImmutableMap.of((Object)"ide:0:0", (Object)new DriveMetrics.Builder().build())).build()).build();

    public void testEmptyMapReturnsNull() {
        Assert.assertEquals((Object)MAP_TO_DRIVE.apply((Map)ImmutableMap.of()), null);
    }

    public void testBasics() {
        ServerInfo expects = new ServerInfo.Builder().name("foo").uuid("hello").vnc(new VNC("auto", null, false)).cpu(1000).mem(2048).metrics(new ServerMetrics.Builder().build()).build();
        Assert.assertEquals((Object)MAP_TO_DRIVE.apply((Map)ImmutableMap.of((Object)"name", (Object)"foo", (Object)"server", (Object)"hello", (Object)"vnc:ip", (Object)"auto", (Object)"cpu", (Object)"1000", (Object)"mem", (Object)"2048")), (Object)expects);
    }

    public void testComplete() throws IOException {
        Map input = (Map)new ListOfKeyValuesDelimitedByBlankLinesToListOfMaps().apply(Strings2.toStringAndClose((InputStream)MapToServerInfoTest.class.getResourceAsStream("/servers.txt"))).get(0);
        Assert.assertEquals((Object)MAP_TO_DRIVE.apply(input), (Object)ONE);
    }

    public void testNew() throws IOException {
        Map input = (Map)new ListOfKeyValuesDelimitedByBlankLinesToListOfMaps().apply(Strings2.toStringAndClose((InputStream)MapToServerInfoTest.class.getResourceAsStream("/new_server.txt"))).get(0);
        Assert.assertEquals((Object)MAP_TO_DRIVE.apply(input), (Object)NEW);
    }
}

