/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.FindResourceInSet;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.domain.ServerStatus;

@Singleton
public class ServerInfoToNodeMetadata
implements Function<ServerInfo, NodeMetadata> {
    public static final Map<ServerStatus, NodeState> serverStatusToNodeState = ImmutableMap.builder().put((Object)ServerStatus.ACTIVE, (Object)NodeState.RUNNING).put((Object)ServerStatus.STOPPED, (Object)NodeState.SUSPENDED).put((Object)ServerStatus.PAUSED, (Object)NodeState.SUSPENDED).put((Object)ServerStatus.DUMPED, (Object)NodeState.PENDING).put((Object)ServerStatus.DEAD, (Object)NodeState.TERMINATED).put((Object)ServerStatus.UNRECOGNIZED, (Object)NodeState.UNRECOGNIZED).build();
    private final Function<Server, String> getImageIdFromServer;
    private final Function<String, Image> findImageForId;
    private final Map<String, Credentials> credentialStore;
    private final Supplier<Location> locationSupplier;
    private final Function<Device, Volume> deviceToVolume;

    @Inject
    ServerInfoToNodeMetadata(Map<String, Credentials> credentialStore, Function<Server, String> getImageIdFromServer, Function<String, Image> findImageForId, Function<Device, Volume> deviceToVolume, Supplier<Location> locationSupplier) {
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.locationSupplier = (Supplier)Preconditions.checkNotNull(locationSupplier, (Object)"locationSupplier");
        this.deviceToVolume = (Function)Preconditions.checkNotNull(deviceToVolume, (Object)"deviceToVolume");
        this.findImageForId = (Function)Preconditions.checkNotNull(findImageForId, (Object)"findImageForId");
        this.getImageIdFromServer = (Function)Preconditions.checkNotNull(getImageIdFromServer, (Object)"getImageIdFromServer");
    }

    public NodeMetadata apply(ServerInfo from) {
        Image image;
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getUuid());
        builder.name(from.getName());
        builder.location((Location)this.locationSupplier.get());
        builder.group(ComputeServiceUtils.parseGroupFromName((String)from.getName()));
        String imageId = (String)this.getImageIdFromServer.apply((Object)from);
        if (imageId != null && (image = (Image)this.findImageForId.apply((Object)imageId)) != null) {
            builder.operatingSystem(image.getOperatingSystem());
        }
        builder.hardware(new HardwareBuilder().ids(from.getUuid()).processors((Iterable)ImmutableList.of((Object)new Processor(1.0, (double)from.getCpu()))).ram(from.getMem()).volumes((Iterable)ImmutableList.of((Object)Iterables.transform(from.getDevices().values(), this.deviceToVolume))).build());
        builder.state(serverStatusToNodeState.get((Object)from.getStatus()));
        builder.publicAddresses((Iterable)ImmutableSet.of((Object)from.getVnc().getIp()));
        builder.privateAddresses((Iterable)ImmutableSet.of());
        builder.credentials(this.credentialStore.get(from.getUuid()));
        return builder.build();
    }

    @Singleton
    public static class FindImageForId
    extends FindResourceInSet<String, Image> {
        @Inject
        public FindImageForId(@Memoized Supplier<Set<? extends Image>> images) {
            super(images);
        }

        public boolean matches(String from, Image input) {
            return input.getProviderId().equals(from);
        }
    }

    @Singleton
    public static class GetImageIdFromServer
    implements Function<Server, String> {
        private final Map<String, DriveInfo> cache;

        @Inject
        public GetImageIdFromServer(Map<String, DriveInfo> cache) {
            this.cache = cache;
        }

        public String apply(Server from) {
            String imageId = null;
            String bootDeviceId = (String)Iterables.get(from.getBootDeviceIds(), (int)0);
            Device bootDevice = from.getDevices().get(bootDeviceId);
            if (bootDevice != null) {
                try {
                    imageId = this.cache.get(bootDevice.getDriveUuid()).getName();
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            return imageId;
        }
    }

    @Singleton
    public static final class DeviceToVolume
    implements Function<Device, Volume> {
        private final Map<String, DriveInfo> cache;

        @Inject
        public DeviceToVolume(Map<String, DriveInfo> cache) {
            this.cache = (Map)Preconditions.checkNotNull(cache, (Object)"cache");
        }

        public Volume apply(Device input) {
            VolumeBuilder builder = new VolumeBuilder();
            builder.id(input.getId());
            DriveInfo drive = this.cache.get(input.getDriveUuid());
            if (drive != null) {
                builder.size(Float.valueOf((float)(drive.getSize() / 1024L) / 1024.0f));
            }
            return new VolumeBuilder().durable(true).type(Volume.Type.NAS).build();
        }
    }
}

