/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.concurrent.Timeout;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.DriveData;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.io.Payload;

@Timeout(duration=60L, timeUnit=TimeUnit.SECONDS)
public interface ElasticStackClient {
    public Set<String> listServers();

    public Set<? extends ServerInfo> listServerInfo();

    public ServerInfo getServerInfo(String var1);

    public ServerInfo createServer(Server var1);

    public ServerInfo setServerConfiguration(String var1, Server var2);

    public void destroyServer(String var1);

    public void startServer(String var1);

    public void stopServer(String var1);

    public void shutdownServer(String var1);

    public void resetServer(String var1);

    public Set<String> listDrives();

    public Set<? extends DriveInfo> listDriveInfo();

    public DriveInfo getDriveInfo(String var1);

    public DriveInfo createDrive(Drive var1);

    public DriveInfo setDriveData(String var1, DriveData var2);

    public void destroyDrive(String var1);

    public ServerInfo createAndStartServer(Server var1);

    public void imageDrive(String var1, String var2);

    public void imageDrive(String var1, String var2, ImageConversionType var3);

    public Payload readDrive(String var1, long var2, long var4);

    public void writeDrive(String var1, Payload var2);

    public void writeDrive(String var1, Payload var2, long var3);
}

