/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.DriveMetrics;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.elasticstack.domain.ServerMetrics;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet;
import org.jclouds.elasticstack.functions.MapToDevices;
import org.jclouds.elasticstack.functions.MapToDriveMetrics;
import org.jclouds.elasticstack.functions.MapToNICs;
import org.jclouds.elasticstack.functions.MapToServerInfoTest;
import org.jclouds.elasticstack.functions.MapToServerMetrics;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListOfKeyValuesDelimitedByBlankLinesToServerInfoSetTest {
    private static final ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet FN = (ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, List<NIC>>>(){}).to(MapToNICs.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, Map<String, ? extends Device>>>(){}).to(MapToDevices.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, Map<String, ? extends DriveMetrics>>>(){}).to(MapToDriveMetrics.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, ServerMetrics>>(){}).to(MapToServerMetrics.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Device, String>>(){}).to(MapToDevices.DeviceToId.class);
        }
    }}).getInstance(ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet.class);

    public void testNone() {
        Assert.assertEquals((Set)FN.apply(new HttpResponse(200, "", (Payload)Payloads.newStringPayload((String)""))), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)FN.apply(new HttpResponse(200, "", (Payload)Payloads.newStringPayload((String)"\n\n"))), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)FN.apply(new HttpResponse(200, "", null)), (Set)ImmutableSet.of());
    }

    public void testOne() {
        Assert.assertEquals((Set)FN.apply(new HttpResponse(200, "", (Payload)Payloads.newInputStreamPayload((InputStream)MapToServerInfoTest.class.getResourceAsStream("/servers.txt")))), (Set)ImmutableSet.of((Object)MapToServerInfoTest.ONE, (Object)MapToServerInfoTest.TWO));
    }
}

