/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Map;
import org.jclouds.elasticstack.domain.ClaimType;
import org.jclouds.elasticstack.domain.CreateDriveRequest;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.functions.CreateDriveRequestToMap;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateDriveRequestToMapTest {
    private static final CreateDriveRequestToMap BASEDRIVE_TO_MAP = (CreateDriveRequestToMap)Guice.createInjector((Module[])new Module[0]).getInstance(CreateDriveRequestToMap.class);

    public void testBasics() {
        Assert.assertEquals((Object)BASEDRIVE_TO_MAP.apply((Drive)new CreateDriveRequest.Builder().name("foo").size(100L).build()), (Object)ImmutableMap.of((Object)"name", (Object)"foo", (Object)"size", (Object)"100"));
    }

    public void testComplete() throws IOException {
        CreateDriveRequest one = new CreateDriveRequest.Builder().name("Ubuntu 10.10 Server Edition Linux 64bit Preinstalled System").size(0x200000000L).claimType(ClaimType.SHARED).readers((Iterable)ImmutableSet.of((Object)"ffffffff-ffff-ffff-ffff-ffffffffffff")).tags((Iterable)ImmutableSet.of((Object)"tag1", (Object)"tag2")).userMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"raz")).encryptionCipher("aes-xts-plain").avoid((Iterable)ImmutableSet.of((Object)"avoid1")).build();
        Assert.assertEquals((Object)BASEDRIVE_TO_MAP.apply((Drive)one), (Object)ImmutableMap.builder().put((Object)"name", (Object)"Ubuntu 10.10 Server Edition Linux 64bit Preinstalled System").put((Object)"size", (Object)"8589934592").put((Object)"claim:type", (Object)"shared").put((Object)"readers", (Object)"ffffffff-ffff-ffff-ffff-ffffffffffff").put((Object)"tags", (Object)"tag1 tag2").put((Object)"user:foo", (Object)"bar").put((Object)"user:baz", (Object)"raz").put((Object)"encryption:cipher", (Object)"aes-xts-plain").put((Object)"avoid", (Object)"avoid1").build());
    }
}

