/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Map;
import org.jclouds.elasticstack.domain.ClaimType;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.functions.BaseDriveToMap;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BaseDriveToMapTest {
    private static final BaseDriveToMap BASEDRIVE_TO_MAP = new BaseDriveToMap();

    public void testBasics() {
        Assert.assertEquals((Object)BASEDRIVE_TO_MAP.apply(new Drive.Builder().name("foo").size(100L).build()), (Object)ImmutableMap.of((Object)"name", (Object)"foo", (Object)"size", (Object)"100"));
    }

    public void testComplete() throws IOException {
        Drive one = new Drive.Builder().name("Ubuntu 10.10 Server Edition Linux 64bit Preinstalled System").size(0x200000000L).claimType(ClaimType.SHARED).readers((Iterable)ImmutableSet.of((Object)"ffffffff-ffff-ffff-ffff-ffffffffffff")).tags((Iterable)ImmutableSet.of((Object)"tag1", (Object)"tag2")).userMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"raz")).build();
        Assert.assertEquals((Object)BASEDRIVE_TO_MAP.apply(one), (Object)ImmutableMap.builder().put((Object)"name", (Object)"Ubuntu 10.10 Server Edition Linux 64bit Preinstalled System").put((Object)"size", (Object)"8589934592").put((Object)"claim:type", (Object)"shared").put((Object)"readers", (Object)"ffffffff-ffff-ffff-ffff-ffffffffffff").put((Object)"tags", (Object)"tag1 tag2").put((Object)"user:foo", (Object)"bar").put((Object)"user:baz", (Object)"raz").build());
    }
}

