/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class CreateInstanceOptions
extends BaseHttpRequestOptions {
    public static final CreateInstanceOptions NONE = new CreateInstanceOptions();

    public CreateInstanceOptions named(String name) {
        this.formParameters.put((Object)"name", Preconditions.checkNotNull((Object)name, (Object)"name"));
        return this;
    }

    public CreateInstanceOptions realm(String realmId) {
        this.formParameters.put((Object)"realm_id", Preconditions.checkNotNull((Object)realmId, (Object)"realmId"));
        return this;
    }

    public CreateInstanceOptions hardwareProfile(String hwpName) {
        this.formParameters.put((Object)"hwp_name", Preconditions.checkNotNull((Object)hwpName, (Object)"hwpName"));
        return this;
    }

    public String getName() {
        return this.getFirstFormOrNull("name");
    }

    public static class Builder {
        public static CreateInstanceOptions named(String name) {
            CreateInstanceOptions options = new CreateInstanceOptions();
            return options.named(name);
        }

        public static CreateInstanceOptions realm(String realmId) {
            CreateInstanceOptions options = new CreateInstanceOptions();
            return options.realm(realmId);
        }

        public static CreateInstanceOptions hardwareProfile(String hwpName) {
            CreateInstanceOptions options = new CreateInstanceOptions();
            return options.hardwareProfile(hwpName);
        }
    }
}

