/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.handlers;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.deltacloud.handlers.DeltacloudErrorHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class DeltacloudErrorHandlerTest {
    @Test
    public void test400MakesIllegalArgumentException() {
        this.assertCodeMakes("GET", URI.create("https://deltacloud.com/foo"), 400, "", "Bad Request", IllegalArgumentException.class);
    }

    @Test
    public void test401MakesAuthorizationException() {
        this.assertCodeMakes("GET", URI.create("https://deltacloud.com/foo"), 401, "", "Unauthorized", AuthorizationException.class);
    }

    @Test
    public void test404MakesResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://deltacloud.com/foo"), 404, "", "Not Found", ResourceNotFoundException.class);
    }

    @Test
    public void testItemNotFoundMakesResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://deltacloud.com/foo"), 500, "", "ItemNotFound", ResourceNotFoundException.class);
    }

    @Test
    public void test405MakesIllegalArgumentException() {
        this.assertCodeMakes("GET", URI.create("https://deltacloud.com/foo"), 405, "", "Method Not Allowed", IllegalArgumentException.class);
    }

    @Test
    public void test409MakesIllegalStateException() {
        this.assertCodeMakes("GET", URI.create("https://deltacloud.com/foo"), 409, "", "Conflict", IllegalStateException.class);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String content, Class<? extends Exception> expected) {
        this.assertCodeMakes(method, uri, statusCode, message, "text/xml", content, expected);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected) {
        DeltacloudErrorHandler function = (DeltacloudErrorHandler)Guice.createInjector((Module[])new Module[0]).getInstance(DeltacloudErrorHandler.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method(method).endpoint(uri).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(statusCode).message(message).payload(content)).build();
        response.getPayload().getContentMetadata().setContentType(contentType);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(DeltacloudErrorHandlerTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }
}

