/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import org.jclouds.deltacloud.domain.EnumHardwareProperty;
import org.jclouds.deltacloud.domain.FixedHardwareProperty;
import org.jclouds.deltacloud.domain.HardwareParameter;
import org.jclouds.deltacloud.domain.HardwareProfile;
import org.jclouds.deltacloud.domain.RangeHardwareProperty;
import org.jclouds.deltacloud.xml.HardwareProfilesHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="HardwareProfilesHandlerTest")
public class HardwareProfilesHandlerTest
extends BaseHandlerTest {
    @Test
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test_list_hardware_profiles.xml");
        ImmutableSet expects = ImmutableSet.of((Object)new HardwareProfile(URI.create("http://localhost:3001/api/hardware_profiles/m1-small"), "m1-small", "m1-small", (Set)ImmutableSet.of((Object)new FixedHardwareProperty("cpu", "count", (Object)1L), (Object)new FixedHardwareProperty("memory", "MB", (Object)new Double(1740.8)), (Object)new FixedHardwareProperty("storage", "GB", (Object)160L), (Object)new FixedHardwareProperty("architecture", "label", (Object)"i386"))), (Object)new HardwareProfile(URI.create("http://localhost:3001/api/hardware_profiles/m1-large"), "m1-large", "m1-large", (Set)ImmutableSet.of((Object)new FixedHardwareProperty("cpu", "count", (Object)2L), (Object)new RangeHardwareProperty("memory", "MB", (Number)10240L, new HardwareParameter(URI.create("http://localhost:3001/api/instances"), "post", "hwp_memory", "create"), (Number)new Double(7680.0), (Number)15360L), (Object)new EnumHardwareProperty("storage", "GB", (Object)850L, new HardwareParameter(URI.create("http://localhost:3001/api/instances"), "post", "hwp_storage", "create"), (Set)ImmutableSet.of((Object)850L, (Object)1024L)), (Object)new FixedHardwareProperty("architecture", "label", (Object)"x86_64"))), (Object)new HardwareProfile(URI.create("http://localhost:3001/api/hardware_profiles/m1-xlarge"), "m1-xlarge", "m1-xlarge", (Set)ImmutableSet.of((Object)new FixedHardwareProperty("cpu", "count", (Object)4L), (Object)new RangeHardwareProperty("memory", "MB", (Number)12288L, new HardwareParameter(URI.create("http://localhost:3001/api/instances"), "post", "hwp_memory", "create"), (Number)12288L, (Number)32768L), (Object)new EnumHardwareProperty("storage", "GB", (Object)1024L, new HardwareParameter(URI.create("http://localhost:3001/api/instances"), "post", "hwp_storage", "create"), (Set)ImmutableSet.of((Object)1024L, (Object)2048L, (Object)4096L)), (Object)new FixedHardwareProperty("architecture", "label", (Object)"x86_64"))), (Object)new HardwareProfile(URI.create("http://localhost:3001/api/hardware_profiles/opaque"), "opaque", "opaque", (Set)ImmutableSet.of()));
        Assert.assertEquals((Set)((Set)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(HardwareProfilesHandler.class)).parse(is)), (Set)expects);
    }
}

