/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.options;

import java.util.Collection;
import java.util.Collections;
import org.jclouds.deltacloud.options.CreateInstanceOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CreateInstanceOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(CreateInstanceOptions.class));
        assert (!String.class.isAssignableFrom(CreateInstanceOptions.class));
    }

    @Test
    public void testWithNamed() {
        CreateInstanceOptions options = new CreateInstanceOptions();
        options.named("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"name"), Collections.singletonList("test"));
    }

    @Test
    public void testNullWithNamed() {
        CreateInstanceOptions options = new CreateInstanceOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"name"), (Collection)Collections.EMPTY_LIST);
    }

    @Test
    public void testWithNamedStatic() {
        CreateInstanceOptions options = CreateInstanceOptions.Builder.named((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"name"), Collections.singletonList("test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithNamedNPE() {
        CreateInstanceOptions.Builder.named(null);
    }
}

