/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.net.HostAndPort;
import com.google.inject.Module;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.deltacloud.DeltacloudApiMetadata;
import org.jclouds.deltacloud.DeltacloudClient;
import org.jclouds.deltacloud.domain.HardwareProfile;
import org.jclouds.deltacloud.domain.Image;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.deltacloud.domain.Realm;
import org.jclouds.deltacloud.domain.Transition;
import org.jclouds.deltacloud.predicates.InstanceFinished;
import org.jclouds.deltacloud.predicates.InstanceRunning;
import org.jclouds.predicates.InetSocketAddressConnect;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.RestContext;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ReadOnlyDeltacloudClientLiveTest")
public class ReadOnlyDeltacloudClientLiveTest
extends BaseComputeServiceContextLiveTest {
    protected DeltacloudClient client;
    protected Predicate<HostAndPort> socketTester;
    protected ImmutableMap<Instance.State, Predicate<Instance>> stateChanges;

    public ReadOnlyDeltacloudClientLiveTest() {
        this.provider = "deltacloud";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.client = (DeltacloudClient)((RestContext)((ComputeServiceContext)this.view).unwrap(DeltacloudApiMetadata.CONTEXT_TOKEN)).getApi();
        this.socketTester = new RetryablePredicate((Predicate)new InetSocketAddressConnect(), 180L, 1L, TimeUnit.SECONDS);
        this.stateChanges = ImmutableMap.of((Object)Instance.State.RUNNING, (Object)new RetryablePredicate((Predicate)new InstanceRunning(this.client), 600L, 1L, TimeUnit.SECONDS), (Object)Instance.State.FINISH, (Object)new RetryablePredicate((Predicate)new InstanceFinished(this.client), 30L, 1L, TimeUnit.SECONDS));
    }

    @Test
    public void testGetLinksContainsAll() throws Exception {
        Set links = this.client.getCollections();
        Assert.assertNotNull((Object)links);
    }

    @Test
    public void testGetInstanceStatesCanGoFromStartToFinish() throws Exception {
        Multimap states = this.client.getInstanceStates();
        Assert.assertNotNull((Object)states);
        Iterable<Transition> toFinishFromStart = this.findChainTo(Instance.State.FINISH, Instance.State.START, (Multimap<Instance.State, ? extends Transition>)states);
        assert (Iterables.size(toFinishFromStart) > 0) : toFinishFromStart;
        Iterable<Transition> toRunningFromStart = this.findChainTo(Instance.State.RUNNING, Instance.State.START, (Multimap<Instance.State, ? extends Transition>)states);
        assert (Iterables.size(toRunningFromStart) > 0) : toRunningFromStart;
        Iterable<Transition> toFinishFromRunning = this.findChainTo(Instance.State.FINISH, Instance.State.RUNNING, (Multimap<Instance.State, ? extends Transition>)states);
        assert (Iterables.size(toFinishFromRunning) > 0) : toFinishFromRunning;
        Assert.assertEquals((Collection)ImmutableList.copyOf((Iterable)Iterables.concat(toRunningFromStart, toFinishFromRunning)), (Collection)ImmutableList.copyOf(toFinishFromStart));
    }

    Iterable<Transition> findChainTo(Instance.State desired, Instance.State currentState, Multimap<Instance.State, ? extends Transition> states) {
        for (Transition transition : states.get((Object)currentState)) {
            if (currentState.ordinal() >= transition.getTo().ordinal()) continue;
            if (transition.getTo() == desired) {
                return ImmutableSet.of((Object)transition);
            }
            Iterable<Transition> transitions = this.findChainTo(desired, transition.getTo(), states);
            if (Iterables.size(transitions) <= 0) continue;
            return Iterables.concat((Iterable)ImmutableSet.of((Object)transition), transitions);
        }
        return ImmutableSet.of();
    }

    public void testListAndGetRealms() throws Exception {
        Set response = this.client.listRealms();
        assert (null != response);
        long realmCount = response.size();
        Assert.assertTrue((realmCount >= 0L ? 1 : 0) != 0);
        for (Realm realm : response) {
            Realm newDetails = this.client.getRealm(realm.getHref());
            Assert.assertEquals((Object)realm, (Object)newDetails);
        }
    }

    public void testListAndGetImages() throws Exception {
        Set response = this.client.listImages();
        assert (null != response);
        long imageCount = response.size();
        Assert.assertTrue((imageCount >= 0L ? 1 : 0) != 0);
        for (Image image : response) {
            Image newDetails = this.client.getImage(image.getHref());
            Assert.assertEquals((Object)image, (Object)newDetails);
        }
    }

    public void testListAndGetHardwareProfiles() throws Exception {
        Set response = this.client.listHardwareProfiles();
        assert (null != response);
        long profileCount = response.size();
        Assert.assertTrue((profileCount >= 0L ? 1 : 0) != 0);
        for (HardwareProfile profile : response) {
            HardwareProfile newDetails = this.client.getHardwareProfile(profile.getHref());
            Assert.assertEquals((Object)profile, (Object)newDetails);
        }
    }

    public void testListAndGetInstances() throws Exception {
        Set response = this.client.listInstances();
        assert (null != response);
        long instanceCount = response.size();
        Assert.assertTrue((instanceCount >= 0L ? 1 : 0) != 0);
        for (Instance instance : response) {
            Instance newDetails = this.client.getInstance(instance.getHref());
            Assert.assertEquals((Object)instance, (Object)newDetails);
        }
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }
}

