/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.deltacloud.DeltacloudApiMetadata;
import org.jclouds.deltacloud.DeltacloudAsyncClient;
import org.jclouds.deltacloud.DeltacloudClient;
import org.jclouds.deltacloud.config.DeltacloudRestClientModule;
import org.jclouds.deltacloud.domain.DeltacloudCollection;
import org.jclouds.deltacloud.functions.ReturnVoidOnRedirectedDelete;
import org.jclouds.deltacloud.options.CreateInstanceOptions;
import org.jclouds.deltacloud.xml.DeltacloudCollectionsHandler;
import org.jclouds.deltacloud.xml.HardwareProfileHandler;
import org.jclouds.deltacloud.xml.HardwareProfilesHandler;
import org.jclouds.deltacloud.xml.ImageHandler;
import org.jclouds.deltacloud.xml.ImagesHandler;
import org.jclouds.deltacloud.xml.InstanceHandler;
import org.jclouds.deltacloud.xml.InstanceStatesHandler;
import org.jclouds.deltacloud.xml.InstancesHandler;
import org.jclouds.deltacloud.xml.RealmHandler;
import org.jclouds.deltacloud.xml.RealmsHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.functions.ReturnEmptyMultimapOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DeltacloudAsyncClientTest")
public class DeltacloudAsyncClientTest
extends BaseAsyncClientTest<DeltacloudAsyncClient> {
    public void testGetCollections() throws SecurityException, NoSuchMethodException, IOException {
        Method method = DeltacloudAsyncClient.class.getMethod("getCollections", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:3001/api HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:3001/api HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/xml\nAuthorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DeltacloudCollectionsHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetInstanceStates() throws IOException, SecurityException, NoSuchMethodException {
        Method method = DeltacloudAsyncClient.class.getMethod("getInstanceStates", new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)request, "GET http://localhost:3001/api/instance_states HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InstanceStatesHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnEmptyMultimapOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListRealms() throws IOException, SecurityException, NoSuchMethodException {
        Method method = DeltacloudAsyncClient.class.getMethod("listRealms", new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)request, "GET http://localhost:3001/api/realms HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, RealmsHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetRealm() throws IOException, SecurityException, NoSuchMethodException {
        Method method = DeltacloudAsyncClient.class.getMethod("getRealm", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://delta/realm1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://delta/realm1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, RealmHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListImages() throws IOException, SecurityException, NoSuchMethodException {
        Method method = DeltacloudAsyncClient.class.getMethod("listImages", new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)request, "GET http://localhost:3001/api/images HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ImagesHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetImage() throws IOException, SecurityException, NoSuchMethodException {
        Method method = DeltacloudAsyncClient.class.getMethod("getImage", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://delta/image1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://delta/image1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ImageHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListHardwareProfiles() throws IOException, SecurityException, NoSuchMethodException {
        Method method = DeltacloudAsyncClient.class.getMethod("listHardwareProfiles", new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)request, "GET http://localhost:3001/api/profiles HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, HardwareProfilesHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetHardwareProfile() throws IOException, SecurityException, NoSuchMethodException {
        Method method = DeltacloudAsyncClient.class.getMethod("getHardwareProfile", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://delta/profile1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://delta/profile1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, HardwareProfileHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListInstances() throws IOException, SecurityException, NoSuchMethodException {
        Method method = DeltacloudAsyncClient.class.getMethod("listInstances", new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)request, "GET http://localhost:3001/api/instances HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InstancesHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetInstance() throws IOException, SecurityException, NoSuchMethodException {
        Method method = DeltacloudAsyncClient.class.getMethod("getInstance", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://delta/instance1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://delta/instance1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InstanceHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateInstance() throws SecurityException, NoSuchMethodException, IOException {
        Method method = DeltacloudAsyncClient.class.getMethod("createInstance", String.class, CreateInstanceOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"imageId-1"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST http://localhost:3001/api/instances HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "image_id=imageId-1", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InstanceHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateInstanceWithOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = DeltacloudAsyncClient.class.getMethod("createInstance", String.class, CreateInstanceOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"imageId-1", CreateInstanceOptions.Builder.named((String)"foo")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST http://localhost:3001/api/instances HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "image_id=imageId-1&name=foo", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InstanceHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testPerformAction() throws IOException, SecurityException, NoSuchMethodException {
        Method method = DeltacloudAsyncClient.class.getMethod("performAction", HttpRequest.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{HttpRequest.builder().method("POST").endpoint("https://delta/instance1/reboot").build()});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://delta/instance1/reboot HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnRedirectedDelete.class);
        this.checkFilters((HttpRequest)request);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), BasicAuthentication.class);
    }

    protected TypeLiteral<RestAnnotationProcessor<DeltacloudAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<DeltacloudAsyncClient>>(){};
    }

    protected Module createModule() {
        return new DeltacloudRestClientModuleExtension();
    }

    protected ApiMetadata createApiMetadata() {
        return new DeltacloudApiMetadata();
    }

    @ConfiguresRestClient
    public static class DeltacloudRestClientModuleExtension
    extends DeltacloudRestClientModule {
        protected Supplier<Set<? extends DeltacloudCollection>> provideCollections(long seconds, DeltacloudClient client) {
            return Suppliers.ofInstance(null);
        }

        protected Supplier<URI> provideImageCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
            return Suppliers.ofInstance((Object)URI.create("http://localhost:3001/api/images"));
        }

        protected Supplier<URI> provideHardwareProfileCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
            return Suppliers.ofInstance((Object)URI.create("http://localhost:3001/api/profiles"));
        }

        protected Supplier<URI> provideInstanceCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
            return Suppliers.ofInstance((Object)URI.create("http://localhost:3001/api/instances"));
        }

        protected Supplier<URI> provideRealmCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
            return Suppliers.ofInstance((Object)URI.create("http://localhost:3001/api/realms"));
        }

        protected Supplier<URI> provideInstanceStateCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
            return Suppliers.ofInstance((Object)URI.create("http://localhost:3001/api/instance_states"));
        }
    }
}

