/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.deltacloud.domain.HardwareProfile;
import org.jclouds.deltacloud.domain.HardwareProperty;

@Singleton
public class HardwareProfileToHardware
implements Function<HardwareProfile, Hardware> {
    public Hardware apply(HardwareProfile from) {
        HardwareBuilder builder = new HardwareBuilder();
        builder.ids(from.getId());
        builder.name(from.getName());
        builder.uri(from.getHref());
        for (HardwareProperty hardwareProperty : from.getProperties()) {
            if (hardwareProperty.getName().equals("memory")) {
                builder.ram(Integer.parseInt(hardwareProperty.getValue().toString()));
                continue;
            }
            if (!hardwareProperty.getName().equals("storage")) continue;
            Float gigs = new Float(hardwareProperty.getValue().toString());
            builder.processors((Iterable)ImmutableList.of((Object)new Processor((double)gigs.floatValue() / 10.0, 1.0)));
            builder.volume(new VolumeBuilder().type(Volume.Type.LOCAL).device("/").size(gigs).bootDevice(true).durable(true).build());
        }
        return builder.build();
    }
}

