/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.deltacloud.DeltacloudClient;
import org.jclouds.deltacloud.domain.HardwareProfile;
import org.jclouds.deltacloud.domain.Image;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.deltacloud.domain.PasswordAuthentication;
import org.jclouds.deltacloud.domain.Realm;
import org.jclouds.deltacloud.domain.Transition;
import org.jclouds.deltacloud.domain.TransitionOnAction;
import org.jclouds.deltacloud.options.CreateInstanceOptions;
import org.jclouds.deltacloud.predicates.InstanceFinished;
import org.jclouds.deltacloud.predicates.InstanceRunning;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.RetryablePredicate;

@Singleton
public class DeltacloudComputeServiceAdapter
implements ComputeServiceAdapter<Instance, HardwareProfile, Image, Realm> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DeltacloudClient client;
    private final ImmutableMap<Instance.State, Predicate<Instance>> stateChanges;

    @Inject
    public DeltacloudComputeServiceAdapter(DeltacloudClient client) {
        this.client = (DeltacloudClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.stateChanges = ImmutableMap.of((Object)((Object)Instance.State.RUNNING), (Object)new RetryablePredicate((Predicate)new InstanceRunning(client), 600L, 1L, TimeUnit.SECONDS), (Object)((Object)Instance.State.FINISH), (Object)new RetryablePredicate((Predicate)new InstanceFinished(client), 30L, 1L, TimeUnit.SECONDS));
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Instance> createNodeWithGroupEncodedIntoName(String tag, String name, Template template) {
        Instance instance = this.client.createInstance(template.getImage().getProviderId(), CreateInstanceOptions.Builder.named(name).hardwareProfile(template.getHardware().getId()).realm(template.getLocation().getId()));
        LoginCredentials creds = null;
        if (instance.getAuthentication() != null && instance.getAuthentication() instanceof PasswordAuthentication) {
            creds = ((PasswordAuthentication)PasswordAuthentication.class.cast(instance.getAuthentication())).getLoginCredentials();
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)instance, instance.getId(), creds);
    }

    public Iterable<HardwareProfile> listHardwareProfiles() {
        return this.client.listHardwareProfiles();
    }

    public Iterable<Image> listImages() {
        return this.client.listImages();
    }

    public Iterable<Instance> listNodes() {
        return this.client.listInstances();
    }

    public Iterable<Realm> listLocations() {
        return this.client.listRealms();
    }

    public Instance getNode(String id) {
        return this.client.getInstance(URI.create((String)Preconditions.checkNotNull((Object)id, (Object)"id")));
    }

    public Image getImage(String id) {
        return this.client.getImage(URI.create((String)Preconditions.checkNotNull((Object)id, (Object)"id")));
    }

    public void destroyNode(String id) {
        Instance instance = this.getNode(id);
        for (Transition transition : this.findChainTo(Instance.State.FINISH, instance.getState(), this.client.getInstanceStates())) {
            Predicate stateTester;
            instance = this.getNode(id);
            if (instance == null) break;
            if (transition instanceof TransitionOnAction) {
                this.client.performAction(instance.getActions().get((Object)((TransitionOnAction)TransitionOnAction.class.cast(transition)).getAction()));
            }
            if ((stateTester = (Predicate)this.stateChanges.get((Object)transition.getTo())) != null) {
                stateTester.apply((Object)instance);
                continue;
            }
            this.logger.debug(String.format("no state tester for: %s", transition), new Object[0]);
        }
    }

    Iterable<Transition> findChainTo(Instance.State desired, Instance.State currentState, Multimap<Instance.State, ? extends Transition> states) {
        for (Transition transition : states.get((Object)currentState)) {
            if (currentState.ordinal() >= transition.getTo().ordinal()) continue;
            if (transition.getTo() == desired) {
                return ImmutableSet.of((Object)transition);
            }
            Iterable<Transition> transitions = this.findChainTo(desired, transition.getTo(), states);
            if (Iterables.size(transitions) <= 0) continue;
            return Iterables.concat((Iterable)ImmutableSet.of((Object)transition), transitions);
        }
        return ImmutableSet.of();
    }

    public void rebootNode(String id) {
        HttpRequest rebootUri = this.getNode(id).getActions().get((Object)Instance.Action.REBOOT);
        if (rebootUri == null) {
            throw new UnsupportedOperationException();
        }
        this.client.performAction(rebootUri);
    }

    public void resumeNode(String id) {
        throw new UnsupportedOperationException();
    }

    public void suspendNode(String id) {
        throw new UnsupportedOperationException();
    }
}

