/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.handlers;

import com.google.inject.Injector;
import org.easymock.EasyMock;
import org.jclouds.ContextBuilder;
import org.jclouds.deltacloud.handlers.DeltacloudRedirectionRetryHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class DeltacloudRedirectionRetryHandlerTest {
    Injector injector = ContextBuilder.newBuilder((String)"stub").buildInjector();

    @Test
    public void test302DoesNotRetryOnDelete() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method("DELETE").endpoint("http://localhost").build();
        HttpResponse response = HttpResponse.builder().statusCode(302).message("HTTP/1.1 302 Found").build();
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{command});
        DeltacloudRedirectionRetryHandler retry = (DeltacloudRedirectionRetryHandler)this.injector.getInstance(DeltacloudRedirectionRetryHandler.class);
        assert (!retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{command});
    }

    @Test
    public void test302DoesRetryOnGET() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost").build();
        HttpResponse response = HttpResponse.builder().statusCode(302).message("HTTP/1.1 302 Found").build();
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        EasyMock.expect((Object)command.incrementRedirectCount()).andReturn((Object)1);
        EasyMock.replay((Object[])new Object[]{command});
        DeltacloudRedirectionRetryHandler retry = (DeltacloudRedirectionRetryHandler)this.injector.getInstance(DeltacloudRedirectionRetryHandler.class);
        assert (!retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{command});
    }
}

