/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.deltacloud.domain.KeyAuthentication;
import org.jclouds.deltacloud.domain.PasswordAuthentication;
import org.jclouds.deltacloud.xml.InstanceHandler;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class InstanceHandlerTest {
    static ParseSax<Instance> createParser() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax parser = ((ParseSax.Factory)injector.getInstance(ParseSax.Factory.class)).create((ParseSax.HandlerWithResult)injector.getInstance(InstanceHandler.class));
        return parser;
    }

    public static Instance parseInstance() {
        return InstanceHandlerTest.parseInstance("/test_get_instance.xml");
    }

    public static Instance parseInstance(String resource) {
        InputStream is = InstanceHandlerTest.class.getResourceAsStream(resource);
        return (Instance)InstanceHandlerTest.createParser().parse(is);
    }

    public void testWithNoAuthentication() {
        Instance expects = this.instanceWithAuthentication(null);
        Assert.assertEquals((String)InstanceHandlerTest.parseInstance("/test_get_instance.xml").toString(), (String)expects.toString());
    }

    public void testWithPasswordAuthentication() {
        Instance expects = this.instanceWithAuthentication((Instance.Authentication)new PasswordAuthentication(LoginCredentials.builder().user("root").password("FOO").build()));
        Assert.assertEquals((String)InstanceHandlerTest.parseInstance("/test_get_instance_pw.xml").toString(), (String)expects.toString());
    }

    public void testWithKeyAuthentication() {
        Instance expects = this.instanceWithAuthentication((Instance.Authentication)new KeyAuthentication("keyname"));
        Assert.assertEquals((String)InstanceHandlerTest.parseInstance("/test_get_instance_key.xml").toString(), (String)expects.toString());
    }

    public void testWithKeyAuthenticationBlank() {
        Instance expects = this.instanceWithAuthentication(null);
        Assert.assertEquals((String)InstanceHandlerTest.parseInstance("/test_get_instance_nokey.xml").toString(), (String)expects.toString());
    }

    private Instance instanceWithAuthentication(Instance.Authentication authentication) {
        return new Instance(URI.create("http://fancycloudprovider.com/api/instances/inst1"), "inst1", "larry", "Production JBoss Instance", URI.create("http://fancycloudprovider.com/api/images/img3"), URI.create("http://fancycloudprovider.com/api/hardware_profiles/m1-small"), URI.create("http://fancycloudprovider.com/api/realms/us"), Instance.State.RUNNING, (Map)ImmutableMap.of((Object)Instance.Action.REBOOT, (Object)new HttpRequest("POST", URI.create("http://fancycloudprovider.com/api/instances/inst1/reboot")), (Object)Instance.Action.STOP, (Object)new HttpRequest("POST", URI.create("http://fancycloudprovider.com/api/instances/inst1/stop"))), authentication, (Set)ImmutableSet.of((Object)"inst1.larry.fancycloudprovider.com"), (Set)ImmutableSet.of((Object)"inst1.larry.internal"));
    }
}

