/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import org.jclouds.deltacloud.domain.EnumHardwareProperty;
import org.jclouds.deltacloud.domain.FixedHardwareProperty;
import org.jclouds.deltacloud.domain.HardwareParameter;
import org.jclouds.deltacloud.domain.HardwareProfile;
import org.jclouds.deltacloud.domain.RangeHardwareProperty;
import org.jclouds.deltacloud.xml.HardwareProfileHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class HardwareProfileHandlerTest {
    static ParseSax<HardwareProfile> createParser() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax parser = ((ParseSax.Factory)injector.getInstance(ParseSax.Factory.class)).create((ParseSax.HandlerWithResult)injector.getInstance(HardwareProfileHandler.class));
        return parser;
    }

    public static HardwareProfile parseHardwareProfile() {
        return HardwareProfileHandlerTest.parseHardwareProfile("/test_get_hardware_profile.xml");
    }

    public static HardwareProfile parseHardwareProfile(String resource) {
        InputStream is = HardwareProfileHandlerTest.class.getResourceAsStream(resource);
        return (HardwareProfile)HardwareProfileHandlerTest.createParser().parse(is);
    }

    public void test() {
        HardwareProfile expects = new HardwareProfile(URI.create("http://localhost:3001/api/hardware_profiles/m1-xlarge"), "m1-xlarge", "m1-xlarge", (Set)ImmutableSet.of((Object)new FixedHardwareProperty("cpu", "count", (Object)new Long(4L)), (Object)new RangeHardwareProperty("memory", "MB", (Number)new Long(12288L), new HardwareParameter(URI.create("http://localhost:3001/api/instances"), "post", "hwp_memory", "create"), (Number)new Long(12288L), (Number)new Long(32768L)), (Object)new EnumHardwareProperty("storage", "GB", (Object)new Long(1024L), new HardwareParameter(URI.create("http://localhost:3001/api/instances"), "post", "hwp_storage", "create"), (Set)ImmutableSet.of((Object)new Long(1024L), (Object)new Long(2048L), (Object)new Long(4096L))), (Object)new FixedHardwareProperty("architecture", "label", (Object)"x86_64")));
        Assert.assertEquals((Object)HardwareProfileHandlerTest.parseHardwareProfile(), (Object)expects);
    }
}

