/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import org.jclouds.deltacloud.domain.Realm;
import org.jclouds.deltacloud.xml.RealmHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class RealmHandlerTest {
    static ParseSax<Realm> createParser() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax parser = ((ParseSax.Factory)injector.getInstance(ParseSax.Factory.class)).create((ParseSax.HandlerWithResult)injector.getInstance(RealmHandler.class));
        return parser;
    }

    public static Realm parseRealm() {
        return RealmHandlerTest.parseRealm("/test_get_realm.xml");
    }

    public static Realm parseRealm(String resource) {
        InputStream is = RealmHandlerTest.class.getResourceAsStream(resource);
        return (Realm)RealmHandlerTest.createParser().parse(is);
    }

    public void test() {
        Realm expects = new Realm(URI.create("http://fancycloudprovider.com/api/realms/us"), "us", "United States", null, Realm.State.AVAILABLE);
        Assert.assertEquals((Object)RealmHandlerTest.parseRealm(), (Object)expects);
    }
}

