/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.functions;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponseException;
import org.jclouds.util.Throwables2;

@Singleton
public class ReturnVoidOnRedirectedDelete
implements Function<Exception, Void> {
    public Void apply(Exception from) {
        HttpResponseException exception = (HttpResponseException)Throwables2.getFirstThrowableOfType((Throwable)from, HttpResponseException.class);
        if (exception != null && exception.getCommand().getCurrentRequest().getMethod().equals("DELETE") && exception.getResponse().getStatusCode() == 302) {
            return null;
        }
        return (Void)Void.class.cast(Throwables2.propagateOrNull((Exception)from));
    }
}

