/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.handlers;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;

@Singleton
public class DeltacloudErrorHandler
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        void var4_11;
        String message = this.parseMessage(response);
        HttpResponseException httpResponseException = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        try {
            String string = message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
            if (message.indexOf("ItemNotFound") != -1) {
                ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)httpResponseException);
            } else {
                switch (response.getStatusCode()) {
                    case 400: {
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(message, (Throwable)httpResponseException);
                        break;
                    }
                    case 401: {
                        AuthorizationException authorizationException = new AuthorizationException(message, (Throwable)httpResponseException);
                        break;
                    }
                    case 404: {
                        if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                        ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)httpResponseException);
                        break;
                    }
                    case 405: {
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(message, (Throwable)httpResponseException);
                        break;
                    }
                    case 409: {
                        IllegalStateException illegalStateException = new IllegalStateException(message, (Throwable)httpResponseException);
                        break;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (response.getPayload() != null) {
                Closeables.closeQuietly((Closeable)response.getPayload().getInput());
            }
            command.setException((Exception)httpResponseException);
            throw throwable;
        }
        if (response.getPayload() != null) {
            Closeables.closeQuietly((Closeable)response.getPayload().getInput());
        }
        command.setException((Exception)var4_11);
    }

    public String parseMessage(HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        try {
            String string = Strings2.toStringAndClose((InputStream)response.getPayload().getInput());
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                response.getPayload().getInput().close();
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }
}

