/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.jclouds.deltacloud.domain.HardwareProperty;

public class HardwareProfile {
    private final URI href;
    private final String id;
    private final String name;
    private final Set<? extends HardwareProperty> properties;

    public HardwareProfile(URI href, String id, String name, Set<? extends HardwareProperty> properties) {
        this.href = (URI)Preconditions.checkNotNull((Object)href, (Object)"href");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.properties = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(properties, (Object)"properties")));
    }

    public URI getHref() {
        return this.href;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<? extends HardwareProperty> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HardwareProfile other = (HardwareProfile)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        return "[href=" + this.href + ", id=" + this.id + ", name=" + this.name + ", properties=" + this.properties + "]";
    }
}

