/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.jclouds.deltacloud.domain.Feature;

public class DeltacloudCollection {
    private final URI href;
    private final String rel;
    private final Set<? extends Feature> features;

    public DeltacloudCollection(URI href, String rel) {
        this(href, rel, (Set<? extends Feature>)ImmutableSet.of());
    }

    public DeltacloudCollection(URI href, String rel, Set<? extends Feature> features) {
        this.href = (URI)Preconditions.checkNotNull((Object)href, (Object)"href");
        this.rel = (String)Preconditions.checkNotNull((Object)rel, (Object)"rel");
        this.features = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(features, (Object)"features")));
    }

    public URI getHref() {
        return this.href;
    }

    public String getRel() {
        return this.rel;
    }

    public Set<? extends Feature> getFeatures() {
        return this.features;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.rel == null ? 0 : this.rel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeltacloudCollection other = (DeltacloudCollection)obj;
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        return !(this.rel == null ? other.rel != null : !this.rel.equals(other.rel));
    }

    public String toString() {
        return "[href=" + this.href + ", rel=" + this.rel + ", features=" + this.features + "]";
    }
}

