/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.compute;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import java.io.IOException;
import org.jclouds.compute.BaseComputeServiceLiveTest;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.LocationScope;
import org.jclouds.rest.RestContext;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, singleThreaded=true, testName="DeltacloudComputeServiceLiveTest")
public class DeltacloudComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    public DeltacloudComputeServiceLiveTest() {
        this.provider = "deltacloud";
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }

    protected void checkUserMetadataInNodeEquals(NodeMetadata node, ImmutableMap<String, String> userMetadata) {
        assert (node.getUserMetadata().equals(ImmutableMap.of())) : String.format("node userMetadata did not match %s %s", userMetadata, node);
    }

    public void testAssignability() throws Exception {
        RestContext tmContext = new ComputeServiceContextFactory().createContext(this.provider, this.identity, this.credential).getProviderSpecificContext();
    }

    protected void checkNodes(Iterable<? extends NodeMetadata> nodes, String group, String task) throws IOException {
        super.checkNodes(nodes, group, task);
        for (NodeMetadata nodeMetadata : nodes) {
            Assert.assertEquals((Object)nodeMetadata.getLocation().getScope(), (Object)LocationScope.ZONE);
        }
    }

    @Test(enabled=true, dependsOnMethods={"testReboot"}, expectedExceptions={UnsupportedOperationException.class})
    public void testSuspendResume() throws Exception {
        super.testSuspendResume();
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testGetNodesWithDetails() throws Exception {
        super.testGetNodesWithDetails();
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testListNodes() throws Exception {
        super.testListNodes();
    }

    @Test(enabled=true, dependsOnMethods={"testListNodes", "testGetNodesWithDetails"})
    public void testDestroyNodes() {
        super.testDestroyNodes();
    }
}

