/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.InputStream;
import java.util.Collection;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.deltacloud.domain.Transition;
import org.jclouds.deltacloud.domain.TransitionAutomatically;
import org.jclouds.deltacloud.domain.TransitionOnAction;
import org.jclouds.deltacloud.xml.InstanceStatesHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="StatesHandlerTest")
public class InstanceStatesHandlerTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test_get_states.xml");
        ImmutableMultimap expects = ImmutableMultimap.builder().put((Object)Instance.State.START, (Object)new TransitionOnAction(Instance.Action.CREATE, Instance.State.PENDING)).put((Object)Instance.State.PENDING, (Object)new TransitionAutomatically(Instance.State.RUNNING)).putAll((Object)Instance.State.RUNNING, (Object[])new Transition[]{new TransitionOnAction(Instance.Action.REBOOT, Instance.State.RUNNING), new TransitionOnAction(Instance.Action.STOP, Instance.State.STOPPED)}).putAll((Object)Instance.State.STOPPED, (Object[])new Transition[]{new TransitionOnAction(Instance.Action.START, Instance.State.RUNNING), new TransitionOnAction(Instance.Action.DESTROY, Instance.State.FINISH)}).build();
        Assert.assertEquals((Collection)((Multimap)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(InstanceStatesHandler.class)).parse(is)).entries(), (Collection)expects.entries());
    }
}

