/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.compute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.compute.BaseTemplateBuilderLiveTest;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class DeltacloudTemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    public DeltacloudTemplateBuilderLiveTest() {
        this.provider = "deltacloud";
    }

    protected Predicate<OsFamilyVersion64Bit> defineUnsupportedOperatingSystems() {
        return Predicates.not((Predicate)new Predicate<OsFamilyVersion64Bit>(){

            public boolean apply(OsFamilyVersion64Bit input) {
                switch (input.family) {
                    case UBUNTU: {
                        return !input.version.startsWith("11") && !input.version.equals("8.04") && input.is64Bit;
                    }
                    case DEBIAN: {
                        return !input.version.equals("6.0") && input.is64Bit;
                    }
                    case CENTOS: {
                        return !input.version.matches("5.[023]") && !input.version.equals("8.04") && input.is64Bit;
                    }
                    case WINDOWS: {
                        return input.version.equals("2008 SP2") || input.version.equals("") || input.version.equals("2008 R2") && input.is64Bit;
                    }
                }
                return false;
            }
        });
    }

    @Test
    public void testTemplateBuilder() {
        Template defaultTemplate = this.context.getComputeService().templateBuilder().build();
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"10.04");
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)defaultTemplate.getLocation().getId(), (String)"http://localhost:3001/api/realms/us");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of();
    }
}

