/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import org.jclouds.deltacloud.domain.Image;
import org.jclouds.deltacloud.xml.ImageHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ImageHandlerTest {
    static ParseSax<Image> createParser() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax parser = ((ParseSax.Factory)injector.getInstance(ParseSax.Factory.class)).create((ParseSax.HandlerWithResult)injector.getInstance(ImageHandler.class));
        return parser;
    }

    public static Image parseImage() {
        return ImageHandlerTest.parseImage("/test_get_image.xml");
    }

    public static Image parseImage(String resource) {
        InputStream is = ImageHandlerTest.class.getResourceAsStream(resource);
        return (Image)ImageHandlerTest.createParser().parse(is);
    }

    public void test() {
        Image expects = new Image(URI.create("http://fancycloudprovider.com/api/images/img1"), "img1", "fedoraproject", "Fedora 10", "Fedora 10", "x86_64");
        Assert.assertEquals((Object)ImageHandlerTest.parseImage(), (Object)expects);
    }
}

