/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.deltacloud.DeltacloudAsyncClient;
import org.jclouds.deltacloud.DeltacloudClient;
import org.jclouds.deltacloud.domain.HardwareProfile;
import org.jclouds.deltacloud.domain.Image;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.deltacloud.domain.Realm;
import org.jclouds.deltacloud.domain.Transition;
import org.jclouds.deltacloud.predicates.InstanceFinished;
import org.jclouds.deltacloud.predicates.InstanceRunning;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.InetSocketAddressConnect;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, sequential=true, testName="ReadOnlyDeltacloudClientLiveTest")
public class ReadOnlyDeltacloudClientLiveTest {
    protected DeltacloudClient client;
    protected RestContext<DeltacloudClient, DeltacloudAsyncClient> context;
    protected String provider = "deltacloud";
    protected String identity;
    protected String credential;
    protected String endpoint;
    protected String apiversion;
    protected Predicate<IPSocket> socketTester;
    protected ImmutableMap<Instance.State, Predicate<Instance>> stateChanges;

    protected void setupCredentials() {
        this.identity = System.getProperty("test." + this.provider + ".identity", "mockuser");
        this.credential = System.getProperty("test." + this.provider + ".credential", "mockpassword");
        this.endpoint = System.getProperty("test." + this.provider + ".endpoint", "http://localhost:3001/api");
        this.apiversion = System.getProperty("test." + this.provider + ".apiversion");
    }

    protected Properties setupProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.trust-all-certs", "true");
        overrides.setProperty("jclouds.relax-hostname", "true");
        overrides.setProperty(this.provider + ".identity", this.identity);
        if (this.credential != null) {
            overrides.setProperty(this.provider + ".credential", this.credential);
        }
        if (this.endpoint != null) {
            overrides.setProperty(this.provider + ".endpoint", this.endpoint);
        }
        if (this.apiversion != null) {
            overrides.setProperty(this.provider + ".apiversion", this.apiversion);
        }
        return overrides;
    }

    @BeforeGroups(groups={"live"})
    public void setupClient() {
        this.setupCredentials();
        Properties overrides = this.setupProperties();
        this.context = new ComputeServiceContextFactory().createContext(this.provider, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule()), overrides).getProviderSpecificContext();
        this.client = (DeltacloudClient)this.context.getApi();
        this.socketTester = new RetryablePredicate((Predicate)new InetSocketAddressConnect(), 180L, 1L, TimeUnit.SECONDS);
        this.stateChanges = ImmutableMap.of((Object)Instance.State.RUNNING, (Object)new RetryablePredicate((Predicate)new InstanceRunning(this.client), 600L, 1L, TimeUnit.SECONDS), (Object)Instance.State.FINISH, (Object)new RetryablePredicate((Predicate)new InstanceFinished(this.client), 30L, 1L, TimeUnit.SECONDS));
    }

    @Test
    public void testGetLinksContainsAll() throws Exception {
        Set links = this.client.getCollections();
        Assert.assertNotNull((Object)links);
    }

    @Test
    public void testGetInstanceStatesCanGoFromStartToFinish() throws Exception {
        Multimap states = this.client.getInstanceStates();
        Assert.assertNotNull((Object)states);
        Iterable<Transition> toFinishFromStart = this.findChainTo(Instance.State.FINISH, Instance.State.START, (Multimap<Instance.State, ? extends Transition>)states);
        assert (Iterables.size(toFinishFromStart) > 0) : toFinishFromStart;
        Iterable<Transition> toRunningFromStart = this.findChainTo(Instance.State.RUNNING, Instance.State.START, (Multimap<Instance.State, ? extends Transition>)states);
        assert (Iterables.size(toRunningFromStart) > 0) : toRunningFromStart;
        Iterable<Transition> toFinishFromRunning = this.findChainTo(Instance.State.FINISH, Instance.State.RUNNING, (Multimap<Instance.State, ? extends Transition>)states);
        assert (Iterables.size(toFinishFromRunning) > 0) : toFinishFromRunning;
        Assert.assertEquals((Collection)ImmutableList.copyOf((Iterable)Iterables.concat(toRunningFromStart, toFinishFromRunning)), (Collection)ImmutableList.copyOf(toFinishFromStart));
    }

    Iterable<Transition> findChainTo(Instance.State desired, Instance.State currentState, Multimap<Instance.State, ? extends Transition> states) {
        for (Transition transition : states.get((Object)currentState)) {
            if (currentState.ordinal() >= transition.getTo().ordinal()) continue;
            if (transition.getTo() == desired) {
                return ImmutableSet.of((Object)transition);
            }
            Iterable<Transition> transitions = this.findChainTo(desired, transition.getTo(), states);
            if (Iterables.size(transitions) <= 0) continue;
            return Iterables.concat((Iterable)ImmutableSet.of((Object)transition), transitions);
        }
        return ImmutableSet.of();
    }

    public void testListAndGetRealms() throws Exception {
        Set response = this.client.listRealms();
        assert (null != response);
        long realmCount = response.size();
        Assert.assertTrue((realmCount >= 0L ? 1 : 0) != 0);
        for (Realm realm : response) {
            Realm newDetails = this.client.getRealm(realm.getHref());
            Assert.assertEquals((Object)realm, (Object)newDetails);
        }
    }

    public void testListAndGetImages() throws Exception {
        Set response = this.client.listImages();
        assert (null != response);
        long imageCount = response.size();
        Assert.assertTrue((imageCount >= 0L ? 1 : 0) != 0);
        for (Image image : response) {
            Image newDetails = this.client.getImage(image.getHref());
            Assert.assertEquals((Object)image, (Object)newDetails);
        }
    }

    public void testListAndGetHardwareProfiles() throws Exception {
        Set response = this.client.listHardwareProfiles();
        assert (null != response);
        long profileCount = response.size();
        Assert.assertTrue((profileCount >= 0L ? 1 : 0) != 0);
        for (HardwareProfile profile : response) {
            HardwareProfile newDetails = this.client.getHardwareProfile(profile.getHref());
            Assert.assertEquals((Object)profile, (Object)newDetails);
        }
    }

    public void testListAndGetInstances() throws Exception {
        Set response = this.client.listInstances();
        assert (null != response);
        long instanceCount = response.size();
        Assert.assertTrue((instanceCount >= 0L ? 1 : 0) != 0);
        for (Instance instance : response) {
            Instance newDetails = this.client.getInstance(instance.getHref());
            Assert.assertEquals((Object)instance, (Object)newDetails);
        }
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        if (this.context != null) {
            this.context.close();
        }
    }
}

