/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.util.logging.Logger;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.deltacloud.ReadOnlyDeltacloudClientLiveTest;
import org.jclouds.deltacloud.domain.Image;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.deltacloud.domain.PasswordAuthentication;
import org.jclouds.deltacloud.domain.Transition;
import org.jclouds.deltacloud.domain.TransitionOnAction;
import org.jclouds.deltacloud.options.CreateInstanceOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.net.IPSocket;
import org.jclouds.ssh.SshClient;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, sequential=true, testName="DeltacloudClientLiveTest")
public class DeltacloudClientLiveTest
extends ReadOnlyDeltacloudClientLiveTest {
    protected String prefix = System.getProperty("user.name") + ".test";
    protected Instance instance;
    protected Credentials creds;

    public void testCreateInstance() throws Exception {
        Logger.getAnonymousLogger().info("starting instance");
        this.instance = this.client.createInstance(((Image)Iterables.find((Iterable)this.client.listImages(), (Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                return input.getDescription().toLowerCase().indexOf("fedora") != -1;
            }
        })).getId(), new CreateInstanceOptions[]{CreateInstanceOptions.Builder.named((String)this.prefix).hardwareProfile("1").realm("us")});
        if (this.instance.getAuthentication() != null && this.instance.getAuthentication() instanceof PasswordAuthentication) {
            this.creds = ((PasswordAuthentication)PasswordAuthentication.class.cast(this.instance.getAuthentication())).getLoginCredentials();
        }
        this.refreshInstance();
        this.checkStartedInstance();
        Instance newInfo = this.client.getInstance(this.instance.getHref());
        this.checkInstanceMatchesGet(newInfo);
    }

    protected void checkInstanceMatchesGet(Instance newInfo) {
        Assert.assertEquals((Object)newInfo.getHref(), (Object)this.instance.getHref());
    }

    protected void checkStartedInstance() {
        System.out.println(new Gson().toJson((Object)this.instance));
        Assert.assertEquals((String)this.instance.getName(), (String)this.prefix);
        assert (((Predicate)this.stateChanges.get((Object)Instance.State.RUNNING)).apply((Object)this.instance)) : this.instance;
        this.refreshInstance();
        Assert.assertEquals((Object)this.instance.getState(), (Object)Instance.State.RUNNING);
    }

    private Instance refreshInstance() {
        if (this.instance != null) {
            this.instance = this.client.getInstance(this.instance.getHref());
            return this.instance;
        }
        return null;
    }

    @Test(dependsOnMethods={"testCreateInstance"})
    public void testConnectivity() throws Exception {
        Logger.getAnonymousLogger().info("awaiting ssh");
        assert (this.socketTester.apply((Object)new IPSocket((String)Iterables.get((Iterable)this.instance.getPublicAddresses(), (int)0), 22))) : this.instance;
        if (this.creds != null) {
            Logger.getAnonymousLogger().info("will connect ssh");
            this.doConnectViaSsh(this.instance, this.creds);
        }
    }

    public HttpRequest getAction(Instance.Action action) {
        return (HttpRequest)this.instance.getActions().get(action);
    }

    @Test(dependsOnMethods={"testConnectivity"})
    public void testLifeCycle() {
        HttpRequest rebootUri = this.getAction(Instance.Action.REBOOT);
        if (rebootUri != null) {
            this.client.performAction(rebootUri);
            assert (((Predicate)this.stateChanges.get((Object)Instance.State.RUNNING)).apply((Object)this.instance)) : this.instance;
        }
    }

    @Test(dependsOnMethods={"testLifeCycle"})
    public void testDestroyInstance() {
        for (Transition transition : this.findChainTo(Instance.State.FINISH, this.refreshInstance().getState(), (Multimap<Instance.State, ? extends Transition>)this.client.getInstanceStates())) {
            Predicate stateTester;
            if (this.refreshInstance() == null) break;
            if (transition instanceof TransitionOnAction) {
                this.client.performAction(this.getAction(((TransitionOnAction)TransitionOnAction.class.cast(transition)).getAction()));
            }
            if ((stateTester = (Predicate)this.stateChanges.get((Object)transition.getTo())) != null) {
                assert (stateTester.apply((Object)this.instance)) : transition + " : " + this.instance;
                continue;
            }
            Logger.getAnonymousLogger().warning(String.format("no state tester for: %s", transition));
        }
        assert (this.refreshInstance() == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnectViaSsh(Instance instance, Credentials creds) throws IOException {
        SshClient ssh = ((SshClient.Factory)Guice.createInjector((Module[])new Module[]{new SshjSshClientModule()}).getInstance(SshClient.Factory.class)).create(new IPSocket((String)Iterables.get((Iterable)instance.getPublicAddresses(), (int)0), 22), creds);
        try {
            ssh.connect();
            ExecResponse hello = ssh.exec("echo hello");
            Assert.assertEquals((String)hello.getOutput().trim(), (String)"hello");
            System.err.println(ssh.exec("df -k").getOutput());
            System.err.println(ssh.exec("mount").getOutput());
            System.err.println(ssh.exec("uname -a").getOutput());
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
    }

    @Override
    protected void tearDown() {
        this.testDestroyInstance();
        super.tearDown();
    }
}

