/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.handlers;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.net.URI;
import javax.inject.Named;
import javax.inject.Singleton;
import org.easymock.classextension.EasyMock;
import org.jclouds.deltacloud.handlers.DeltacloudRedirectionRetryHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.BaseRestClientTest;
import org.jclouds.rest.config.RestModule;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class DeltacloudRedirectionRetryHandlerTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new BaseRestClientTest.MockModule(), new RestModule(), new AbstractModule(){

        @Provides
        @Singleton
        @Named(value="CONSTANTS")
        protected Multimap<String, String> constants() {
            return LinkedHashMultimap.create();
        }

        protected void configure() {
        }
    }});

    @Test
    public void test302DoesNotRetryOnDelete() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method("DELETE").endpoint(URI.create("http://localhost")).build();
        HttpResponse response = new HttpResponse(302, "HTTP/1.1 302 Found", null);
        org.easymock.EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{command});
        DeltacloudRedirectionRetryHandler retry = (DeltacloudRedirectionRetryHandler)this.injector.getInstance(DeltacloudRedirectionRetryHandler.class);
        assert (!retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{command});
    }

    @Test
    public void test302DoesRetryOnGET() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost")).build();
        HttpResponse response = new HttpResponse(302, "HTTP/1.1 302 Found", null);
        org.easymock.EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        org.easymock.EasyMock.expect((Object)command.incrementRedirectCount()).andReturn((Object)1);
        EasyMock.replay((Object[])new Object[]{command});
        DeltacloudRedirectionRetryHandler retry = (DeltacloudRedirectionRetryHandler)this.injector.getInstance(DeltacloudRedirectionRetryHandler.class);
        assert (!retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{command});
    }
}

