/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.ZoneAsyncClient;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateZoneOptions;
import org.jclouds.cloudstack.options.UpdateZoneOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GlobalZoneAsyncClient
extends ZoneAsyncClient {
    @Named(value="createZone")
    @GET
    @QueryParams(keys={"command"}, values={"createZone"})
    @SelectJson(value={"zone"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Zone> createZone(@QueryParam(value="name") String var1, @QueryParam(value="networktype") NetworkType var2, @QueryParam(value="dns1") String var3, @QueryParam(value="internaldns1") String var4, CreateZoneOptions ... var5);

    @Named(value="updateZone")
    @GET
    @QueryParams(keys={"command"}, values={"updateZone"})
    @SelectJson(value={"zone"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Zone> updateZone(@QueryParam(value="id") String var1, UpdateZoneOptions ... var2);

    @Named(value="deleteZone")
    @GET
    @QueryParams(keys={"command"}, values={"deleteZone"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteZone(@QueryParam(value="id") String var1);
}

