/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.jclouds.cloudstack.options.ListUsageRecordsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListUsageRecordsOptionsTest {
    public void testAccountInDomain() {
        ListUsageRecordsOptions options = new ListUsageRecordsOptions().accountInDomain("fred", "42");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"fred"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testAccountInDomainStatic() {
        ListUsageRecordsOptions options = ListUsageRecordsOptions.Builder.accountInDomain((String)"fred", (String)"42");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"fred"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testDomainId() {
        ListUsageRecordsOptions options = new ListUsageRecordsOptions().domainId("42");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testDomainIdStatic() {
        ListUsageRecordsOptions options = ListUsageRecordsOptions.Builder.domainId((String)"42");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testAccountId() {
        ListUsageRecordsOptions options = new ListUsageRecordsOptions().accountId("41");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"41"), (Collection)options.buildQueryParameters().get((Object)"accountid"));
    }

    public void testAccountIdStatic() {
        ListUsageRecordsOptions options = ListUsageRecordsOptions.Builder.accountId((String)"41");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"41"), (Collection)options.buildQueryParameters().get((Object)"accountid"));
    }

    public void testKeyword() {
        ListUsageRecordsOptions options = new ListUsageRecordsOptions().keyword("bob");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"bob"), (Collection)options.buildQueryParameters().get((Object)"keyword"));
    }

    public void testKeywordStatic() {
        ListUsageRecordsOptions options = ListUsageRecordsOptions.Builder.keyword((String)"bob");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"bob"), (Collection)options.buildQueryParameters().get((Object)"keyword"));
    }
}

