/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.jclouds.cloudstack.CloudStackApiMetadata;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.features.VolumeClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VolumeClientExpectTest")
public class VolumeClientExpectTest
extends BaseCloudStackExpectTest<VolumeClient> {
    public void testCreateVolumeFromCustomDiskOffering() throws NoSuchAlgorithmException, CertificateException {
        VolumeClient client = (VolumeClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createVolume&name=VolumeClientExpectTest-jclouds-volume&diskofferingid=0473f5dd-bca5-4af4-a9b6-db9e8a88a2f6&zoneid=6f9a2921-b22a-4149-8b71-6ffc275a2177&size=1&apiKey=identity&signature=Y4%2BmdvhS/jlKRNSJ3nQqrjwg1CY%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/queryasyncjobresultresponse-createvolume.json"))).build());
        AsyncCreateResponse response = client.createVolumeFromCustomDiskOfferingInZone("VolumeClientExpectTest-jclouds-volume", "0473f5dd-bca5-4af4-a9b6-db9e8a88a2f6", "6f9a2921-b22a-4149-8b71-6ffc275a2177", 1);
        Assert.assertNotNull((Object)response);
    }

    @Override
    protected VolumeClient clientFrom(CloudStackContext context) {
        return ((CloudStackClient)((RestContext)context.unwrap(CloudStackApiMetadata.CONTEXT_TOKEN)).getApi()).getVolumeClient();
    }
}

