/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Pod;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.CreatePodOptions;
import org.jclouds.cloudstack.options.CreateZoneOptions;
import org.jclouds.cloudstack.options.ListPodsOptions;
import org.jclouds.cloudstack.options.UpdatePodOptions;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalPodClientLiveTest")
public class GlobalPodClientLiveTest
extends BaseCloudStackClientLiveTest {
    private Zone zone;
    private Pod pod;

    public void testListPods() throws Exception {
        this.skipIfNotGlobalAdmin();
        Set response = this.globalAdminClient.getPodClient().listPods(new ListPodsOptions[0]);
        assert (null != response);
        long podCount = response.size();
        Assert.assertTrue((podCount >= 0L ? 1 : 0) != 0);
        for (Pod pod : response) {
            Pod newDetails = (Pod)Iterables.getOnlyElement((Iterable)this.globalAdminClient.getPodClient().listPods(new ListPodsOptions[]{ListPodsOptions.Builder.id((String)pod.getId())}));
            Assert.assertEquals((Object)pod, (Object)newDetails);
            Assert.assertEquals((Object)pod, (Object)this.globalAdminClient.getPodClient().getPod(pod.getId()));
            Assert.assertNotNull((Object)pod.getId());
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pod.getName()));
            Assert.assertNotNull((Object)pod.getZoneId());
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pod.getZoneName()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pod.getGateway()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pod.getNetmask()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pod.getStartIp()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pod.getEndIp()));
            Assert.assertNotEquals((Object)pod.getAllocationState(), (Object)AllocationState.UNKNOWN);
        }
    }

    @Test
    public void testCreatePod() {
        this.skipIfNotGlobalAdmin();
        this.zone = this.globalAdminClient.getZoneClient().createZone(this.prefix + "-zone", NetworkType.BASIC, "8.8.8.8", "10.10.10.10", new CreateZoneOptions[0]);
        this.pod = this.globalAdminClient.getPodClient().createPod(this.prefix + "-pod", this.zone.getId(), "172.20.0.1", "172.20.0.250", "172.20.0.254", "255.255.255.0", new CreatePodOptions[]{CreatePodOptions.Builder.allocationState((AllocationState)AllocationState.ENABLED)});
        Assert.assertNotNull((Object)this.pod);
        Assert.assertEquals((String)this.pod.getName(), (String)(this.prefix + "-pod"));
        Assert.assertEquals((String)this.pod.getZoneId(), (String)this.zone.getId());
        Assert.assertEquals((String)this.pod.getZoneName(), (String)(this.prefix + "-zone"));
        Assert.assertEquals((String)this.pod.getStartIp(), (String)"172.20.0.1");
        Assert.assertEquals((String)this.pod.getEndIp(), (String)"172.20.0.250");
        Assert.assertEquals((String)this.pod.getGateway(), (String)"172.20.0.254");
        Assert.assertEquals((String)this.pod.getNetmask(), (String)"255.255.255.0");
        Assert.assertEquals((Object)this.pod.getAllocationState(), (Object)AllocationState.ENABLED);
    }

    @Test(dependsOnMethods={"testCreatePod"})
    public void testUpdatePod() {
        Pod updated = this.globalAdminClient.getPodClient().updatePod(this.pod.getId(), new UpdatePodOptions[]{UpdatePodOptions.Builder.name((String)(this.prefix + "-updatedpod")).startIp("172.21.0.129").endIp("172.21.0.250").gateway("172.21.0.254").netmask("255.255.255.128").allocationState(AllocationState.DISABLED)});
        Assert.assertNotNull((Object)updated);
        Assert.assertEquals((String)updated.getName(), (String)(this.prefix + "-updatedpod"));
        Assert.assertEquals((String)updated.getZoneId(), (String)this.zone.getId());
        Assert.assertEquals((String)updated.getZoneName(), (String)(this.prefix + "-zone"));
        Assert.assertEquals((String)updated.getStartIp(), (String)"172.21.0.129");
        Assert.assertEquals((String)updated.getEndIp(), (String)"172.21.0.250");
        Assert.assertEquals((String)updated.getGateway(), (String)"172.21.0.254");
        Assert.assertEquals((String)updated.getNetmask(), (String)"255.255.255.128");
        Assert.assertEquals((Object)updated.getAllocationState(), (Object)AllocationState.DISABLED);
    }

    @AfterGroups(groups={"live"})
    protected void tearDownContext() {
        if (this.pod != null) {
            this.globalAdminClient.getPodClient().deletePod(this.pod.getId());
            this.pod = null;
        }
        if (this.zone != null) {
            this.globalAdminClient.getZoneClient().deleteZone(this.zone.getId());
            this.zone = null;
        }
        super.tearDownContext();
    }
}

