/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Set;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.features.GlobalAccountClientLiveTest;
import org.jclouds.cloudstack.features.GlobalUserClientLiveTest;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListUsersOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="DomainUserClientLiveTest")
public class DomainUserClientLiveTest
extends BaseCloudStackClientLiveTest {
    @Test
    public void testListUsers() {
        this.skipIfNotDomainAdmin();
        Set users = this.domainAdminClient.getUserClient().listUsers(new ListUsersOptions[0]);
        assert (users.size() > 0);
        assert (users.contains(this.user));
        for (User user : users) {
            this.checkUser(user);
        }
    }

    private void checkUser(User user) {
        assert (user.getId() != null);
        assert (user.getAccount() != null);
        assert (user.getDomain() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableDisableUser() {
        this.skipIfNotGlobalAdmin();
        Account testAccount = null;
        User testUser = null;
        try {
            testAccount = GlobalAccountClientLiveTest.createTestAccount(this.globalAdminClient, this.prefix);
            testUser = GlobalUserClientLiveTest.createTestUser(this.globalAdminClient, testAccount, this.prefix);
            AsyncCreateResponse response = this.domainAdminClient.getUserClient().disableUser(testUser.getId());
            Assert.assertNotNull((Object)response);
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)response.getJobId()));
            AsyncJob job = this.domainAdminClient.getAsyncJobClient().getAsyncJob(response.getJobId());
            Assert.assertNotNull((Object)job);
            Assert.assertEquals((Object)((User)job.getResult()).getState(), (Object)User.State.DISABLED);
            User updated = this.domainAdminClient.getUserClient().enableUser(testUser.getId());
            Assert.assertNotNull((Object)updated);
            Assert.assertEquals((Object)updated.getState(), (Object)User.State.ENABLED);
        }
        finally {
            if (testUser != null) {
                this.globalAdminClient.getUserClient().deleteUser(testUser.getId());
            }
            if (testAccount != null) {
                this.globalAdminClient.getAccountClient().deleteAccount(testAccount.getId());
            }
        }
    }
}

