/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.features.AsyncJobAsyncClient;
import org.jclouds.cloudstack.functions.ParseAsyncJobFromHttpResponse;
import org.jclouds.cloudstack.functions.ParseAsyncJobsFromHttpResponse;
import org.jclouds.cloudstack.internal.BaseCloudStackAsyncClientTest;
import org.jclouds.cloudstack.options.ListAsyncJobsOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AsyncJobAsyncClientTest")
public class AsyncJobAsyncClientTest
extends BaseCloudStackAsyncClientTest<AsyncJobAsyncClient> {
    public void testGetAsyncJob() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AsyncJobAsyncClient.class, (String)"getAsyncJob", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)11L));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=queryAsyncJobResult&jobid=11 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseAsyncJobFromHttpResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListAsyncJobs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AsyncJobAsyncClient.class, (String)"listAsyncJobs", (Class[])new Class[]{ListAsyncJobsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listAsyncJobs&listAll=true HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseAsyncJobsFromHttpResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListAsyncJobsOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AsyncJobAsyncClient.class, (String)"listAsyncJobs", (Class[])new Class[]{ListAsyncJobsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListAsyncJobsOptions.Builder.accountInDomain((String)"adrian", (String)"5")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listAsyncJobs&listAll=true&account=adrian&domainid=5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseAsyncJobsFromHttpResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

