/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.jclouds.Fallback;
import org.jclouds.Fallbacks;
import org.jclouds.util.Throwables2;

public final class CloudStackFallbacks {
    private CloudStackFallbacks() {
    }

    public static final class VoidOnNotFoundOr404OrUnableToFindAccountOwner
    implements Fallback<Void> {
        public ListenableFuture<Void> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Void createOrPropagate(Throwable t) throws Exception {
            IllegalStateException e = (IllegalStateException)Throwables2.getFirstThrowableOfType((Throwable)((Throwable)Preconditions.checkNotNull((Object)t, (Object)"throwable")), IllegalStateException.class);
            if (e != null && e.getMessage().indexOf("Unable to find account owner for") != -1) {
                return null;
            }
            return (Void)Fallbacks.valOnNotFoundOr404(null, (Throwable)t);
        }
    }
}

