/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.ListUsersOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface DomainUserAsyncClient {
    @Named(value="listUsers")
    @GET
    @QueryParams(keys={"command"}, values={"listUsers"})
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<User>> listUsers(ListUsersOptions ... var1);

    @Named(value="enableUser")
    @GET
    @QueryParams(keys={"command"}, values={"enableUser"})
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<User> enableUser(@QueryParam(value="id") String var1);

    @Named(value="disableUser")
    @GET
    @QueryParams(keys={"command"}, values={"disableUser"})
    @Unwrap
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<AsyncCreateResponse> disableUser(@QueryParam(value="id") String var1);
}

