/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.OptionsConverter;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.Capabilities;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.domain.ServiceOffering;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.functions.CreateFirewallRulesForIP;
import org.jclouds.cloudstack.functions.CreatePortForwardingRulesForIP;
import org.jclouds.cloudstack.functions.StaticNATVirtualMachineInNetwork;
import org.jclouds.cloudstack.options.DeployVirtualMachineOptions;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListServiceOfferingsOptions;
import org.jclouds.cloudstack.options.ListTemplatesOptions;
import org.jclouds.cloudstack.options.ListVirtualMachinesOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.cloudstack.predicates.TemplatePredicates;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

@Singleton
public class CloudStackComputeServiceAdapter
implements ComputeServiceAdapter<VirtualMachine, ServiceOffering, Template, Zone> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudStackClient client;
    private final Predicate<String> jobComplete;
    private final Supplier<Map<String, Network>> networkSupplier;
    private final BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult;
    private final StaticNATVirtualMachineInNetwork.Factory staticNATVMInNetwork;
    private final CreatePortForwardingRulesForIP setupPortForwardingRulesForIP;
    private final CreateFirewallRulesForIP setupFirewallRulesForIP;
    private final LoadingCache<String, Set<IPForwardingRule>> vmToRules;
    private final Map<String, Credentials> credentialStore;
    private final Map<NetworkType, ? extends OptionsConverter> optionsConverters;
    private final Supplier<LoadingCache<String, Zone>> zoneIdToZone;

    @Inject
    public CloudStackComputeServiceAdapter(CloudStackClient client, Predicate<String> jobComplete, @Memoized Supplier<Map<String, Network>> networkSupplier, BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult, StaticNATVirtualMachineInNetwork.Factory staticNATVMInNetwork, CreatePortForwardingRulesForIP setupPortForwardingRulesForIP, CreateFirewallRulesForIP setupFirewallRulesForIP, LoadingCache<String, Set<IPForwardingRule>> vmToRules, Map<String, Credentials> credentialStore, Map<NetworkType, ? extends OptionsConverter> optionsConverters, Supplier<LoadingCache<String, Zone>> zoneIdToZone) {
        this.client = (CloudStackClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.jobComplete = (Predicate)Preconditions.checkNotNull(jobComplete, (Object)"jobComplete");
        this.networkSupplier = (Supplier)Preconditions.checkNotNull(networkSupplier, (Object)"networkSupplier");
        this.blockUntilJobCompletesAndReturnResult = (BlockUntilJobCompletesAndReturnResult)Preconditions.checkNotNull((Object)blockUntilJobCompletesAndReturnResult, (Object)"blockUntilJobCompletesAndReturnResult");
        this.staticNATVMInNetwork = (StaticNATVirtualMachineInNetwork.Factory)Preconditions.checkNotNull((Object)staticNATVMInNetwork, (Object)"staticNATVMInNetwork");
        this.setupPortForwardingRulesForIP = (CreatePortForwardingRulesForIP)Preconditions.checkNotNull((Object)setupPortForwardingRulesForIP, (Object)"setupPortForwardingRulesForIP");
        this.setupFirewallRulesForIP = (CreateFirewallRulesForIP)Preconditions.checkNotNull((Object)setupFirewallRulesForIP, (Object)"setupFirewallRulesForIP");
        this.vmToRules = (LoadingCache)Preconditions.checkNotNull(vmToRules, (Object)"vmToRules");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.optionsConverters = optionsConverters;
        this.zoneIdToZone = zoneIdToZone;
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<VirtualMachine> createNodeWithGroupEncodedIntoName(String group, String name, org.jclouds.compute.domain.Template template) {
        Preconditions.checkNotNull((Object)template, (Object)"template was null");
        Preconditions.checkNotNull((Object)template.getOptions(), (Object)"template options was null");
        Preconditions.checkArgument((boolean)template.getOptions().getClass().isAssignableFrom(CloudStackTemplateOptions.class), (String)"options class %s should have been assignable from CloudStackTemplateOptions", (Object[])new Object[]{template.getOptions().getClass()});
        Map networks = (Map)this.networkSupplier.get();
        String zoneId = template.getLocation().getId();
        Zone zone = null;
        try {
            zone = (Zone)((LoadingCache)this.zoneIdToZone.get()).get((Object)zoneId);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
        CloudStackTemplateOptions templateOptions = (CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class);
        Preconditions.checkState((boolean)this.optionsConverters.containsKey((Object)zone.getNetworkType()), (String)"no options converter configured for network type %s", (Object[])new Object[]{zone.getNetworkType()});
        DeployVirtualMachineOptions options = DeployVirtualMachineOptions.Builder.displayName(name).name(name);
        if (templateOptions.getAccount() != null) {
            options.accountInDomain(templateOptions.getAccount(), templateOptions.getDomainId());
        } else if (templateOptions.getDomainId() != null) {
            options.domainId(templateOptions.getDomainId());
        }
        OptionsConverter optionsConverter = this.optionsConverters.get((Object)zone.getNetworkType());
        options = optionsConverter.apply(templateOptions, networks, zoneId, options);
        if (templateOptions.getIpOnDefaultNetwork() != null) {
            options.ipOnDefaultNetwork(templateOptions.getIpOnDefaultNetwork());
        }
        if (templateOptions.getIpsToNetworks().size() > 0) {
            options.ipsToNetworks(templateOptions.getIpsToNetworks());
        }
        if (templateOptions.getKeyPair() != null) {
            options.keyPair(templateOptions.getKeyPair());
            if (templateOptions.getRunScript() != null) {
                Preconditions.checkArgument((boolean)this.credentialStore.containsKey("keypair#" + templateOptions.getKeyPair()), (String)"no private key configured for: %s; please use options.overrideLoginCredentialWith(rsa_private_text)", (Object[])new Object[]{templateOptions.getKeyPair()});
            }
        }
        String templateId = template.getImage().getId();
        String serviceOfferingId = template.getHardware().getId();
        this.logger.debug("serviceOfferingId %s, templateId %s, zoneId %s, options %s%n", new Object[]{serviceOfferingId, templateId, zoneId, options});
        AsyncCreateResponse job = this.client.getVirtualMachineClient().deployVirtualMachineInZone(zoneId, serviceOfferingId, templateId, options);
        VirtualMachine vm = (VirtualMachine)this.blockUntilJobCompletesAndReturnResult.apply(job);
        this.logger.debug("--- virtualmachine: %s", new Object[]{vm});
        LoginCredentials credentials = null;
        if (vm.isPasswordEnabled()) {
            assert (vm.getPassword() != null) : vm;
            credentials = LoginCredentials.builder().password(vm.getPassword()).build();
        } else {
            credentials = LoginCredentials.fromCredentials((Credentials)this.credentialStore.get("keypair#" + templateOptions.getKeyPair()));
        }
        if (templateOptions.shouldSetupStaticNat()) {
            Capabilities capabilities = this.client.getConfigurationClient().listCapabilities();
            for (String networkId : options.getNetworkIds()) {
                Set<Comparable<IPForwardingRule>> rules;
                this.logger.debug(">> creating static NAT for virtualMachine(%s) in network(%s)", new Object[]{vm.getId(), networkId});
                PublicIPAddress ip = this.staticNATVMInNetwork.create((Network)networks.get(networkId)).apply(vm);
                this.logger.trace("<< static NATed IPAddress(%s) to virtualMachine(%s)", new Object[]{ip.getId(), vm.getId()});
                vm = this.client.getVirtualMachineClient().getVirtualMachine(vm.getId());
                List ports = Ints.asList((int[])templateOptions.getInboundPorts());
                if (capabilities.getCloudStackVersion().startsWith("2")) {
                    this.logger.debug(">> setting up IP forwarding for IPAddress(%s) rules(%s)", new Object[]{ip.getId(), ports});
                    rules = this.setupPortForwardingRulesForIP.apply(ip, ports);
                    this.logger.trace("<< setup %d IP forwarding rules on IPAddress(%s)", new Object[]{rules.size(), ip.getId()});
                    continue;
                }
                this.logger.debug(">> setting up firewall rules for IPAddress(%s) rules(%s)", new Object[]{ip.getId(), ports});
                rules = this.setupFirewallRulesForIP.apply(ip, ports);
                this.logger.trace("<< setup %d firewall rules on IPAddress(%s)", new Object[]{rules.size(), ip.getId()});
            }
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)vm, vm.getId() + "", credentials);
    }

    public Iterable<ServiceOffering> listHardwareProfiles() {
        return this.client.getOfferingClient().listServiceOfferings(new ListServiceOfferingsOptions[0]);
    }

    public Iterable<Template> listImages() {
        return Iterables.filter(this.client.getTemplateClient().listTemplates(), TemplatePredicates.isReady());
    }

    public Template getImage(String id) {
        return (Template)Iterables.get(this.client.getTemplateClient().listTemplates(ListTemplatesOptions.Builder.id(id)), (int)0, null);
    }

    public Iterable<VirtualMachine> listNodes() {
        return this.client.getVirtualMachineClient().listVirtualMachines(new ListVirtualMachinesOptions[0]);
    }

    public Iterable<Zone> listLocations() {
        return this.client.getZoneClient().listZones(new ListZonesOptions[0]);
    }

    public VirtualMachine getNode(String id) {
        String virtualMachineId = id;
        return this.client.getVirtualMachineClient().getVirtualMachine(virtualMachineId);
    }

    public void destroyNode(String id) {
        String virtualMachineId = id;
        Set<String> ipAddresses = this.deleteIPForwardingRulesForVMAndReturnDistinctIPs(virtualMachineId);
        ipAddresses.addAll(this.deleteFirewallRulesForVMAndReturnDistinctIPs(virtualMachineId));
        this.disableStaticNATOnIPAddresses(ipAddresses);
        this.disassociateIPAddresses(ipAddresses);
        this.destroyVirtualMachine(virtualMachineId);
        this.vmToRules.invalidate((Object)virtualMachineId);
    }

    public void disassociateIPAddresses(Set<String> ipAddresses) {
        for (String ipAddress : ipAddresses) {
            this.logger.debug(">> disassociating IPAddress(%s)", new Object[]{ipAddress});
            this.client.getAddressClient().disassociateIPAddress(ipAddress);
        }
    }

    public void destroyVirtualMachine(String virtualMachineId) {
        String destroyVirtualMachine = this.client.getVirtualMachineClient().destroyVirtualMachine(virtualMachineId);
        if (destroyVirtualMachine != null) {
            this.logger.debug(">> destroying virtualMachine(%s) job(%s)", new Object[]{virtualMachineId, destroyVirtualMachine});
            this.awaitCompletion(destroyVirtualMachine);
        } else {
            this.logger.trace("<< virtualMachine(%s) not found", new Object[]{virtualMachineId});
        }
    }

    public void disableStaticNATOnIPAddresses(Set<String> ipAddresses) {
        ImmutableSet.Builder jobsToTrack = ImmutableSet.builder();
        for (String ipAddress : ipAddresses) {
            String disableStaticNAT = this.client.getNATClient().disableStaticNATOnPublicIP(ipAddress);
            if (disableStaticNAT == null) continue;
            this.logger.debug(">> disabling static NAT IPAddress(%s) job(%s)", new Object[]{ipAddress, disableStaticNAT});
            jobsToTrack.add((Object)disableStaticNAT);
        }
        this.awaitCompletion((Iterable<String>)jobsToTrack.build());
    }

    public Set<String> deleteIPForwardingRulesForVMAndReturnDistinctIPs(String virtualMachineId) {
        ImmutableSet.Builder jobsToTrack = ImmutableSet.builder();
        LinkedHashSet ipAddresses = Sets.newLinkedHashSet();
        Set<IPForwardingRule> forwardingRules = this.client.getNATClient().getIPForwardingRulesForVirtualMachine(virtualMachineId);
        for (IPForwardingRule rule : forwardingRules) {
            if ("Deleting".equals(rule.getState())) continue;
            ipAddresses.add(rule.getIPAddressId());
            String deleteForwardingRule = this.client.getNATClient().deleteIPForwardingRule(rule.getId());
            if (deleteForwardingRule == null) continue;
            this.logger.debug(">> deleting IPForwardingRule(%s) job(%s)", new Object[]{rule.getId(), deleteForwardingRule});
            jobsToTrack.add((Object)deleteForwardingRule);
        }
        this.awaitCompletion((Iterable<String>)jobsToTrack.build());
        return ipAddresses;
    }

    public Set<String> deleteFirewallRulesForVMAndReturnDistinctIPs(String virtualMachineId) {
        LinkedHashSet ipAddresses = Sets.newLinkedHashSet();
        String publicIpId = this.client.getVirtualMachineClient().getVirtualMachine(virtualMachineId).getPublicIPId();
        if (publicIpId != null) {
            Set<FirewallRule> firewallRules = this.client.getFirewallClient().listFirewallRules(ListFirewallRulesOptions.Builder.ipAddressId(this.client.getVirtualMachineClient().getVirtualMachine(virtualMachineId).getPublicIPId()));
            for (FirewallRule rule : firewallRules) {
                if (rule.getState() == FirewallRule.State.DELETING) continue;
                ipAddresses.add(rule.getIpAddressId());
                this.client.getFirewallClient().deleteFirewallRule(rule.getId());
                this.logger.debug(">> deleting FirewallRule(%s)", new Object[]{rule.getId()});
            }
        }
        return ipAddresses;
    }

    public void awaitCompletion(Iterable<String> jobs) {
        this.logger.debug(">> awaiting completion of jobs(%s)", new Object[]{jobs});
        for (String job : jobs) {
            this.awaitCompletion(job);
        }
        this.logger.trace("<< completed jobs(%s)", new Object[]{jobs});
    }

    public void awaitCompletion(String job) {
        boolean completed = this.jobComplete.apply((Object)job);
        this.logger.trace("<< job(%s) complete(%s)", new Object[]{job, completed});
    }

    public void rebootNode(String id) {
        String virtualMachineId = id;
        String job = this.client.getVirtualMachineClient().rebootVirtualMachine(virtualMachineId);
        if (job != null) {
            this.logger.debug(">> rebooting virtualMachine(%s) job(%s)", new Object[]{virtualMachineId, job});
            this.awaitCompletion(job);
        }
    }

    public void resumeNode(String id) {
        String virtualMachineId = id;
        String job = this.client.getVirtualMachineClient().startVirtualMachine(id);
        if (job != null) {
            this.logger.debug(">> starting virtualMachine(%s) job(%s)", new Object[]{virtualMachineId, job});
            this.awaitCompletion(job);
        }
    }

    public void suspendNode(String id) {
        String virtualMachineId = id;
        String job = this.client.getVirtualMachineClient().stopVirtualMachine(id);
        if (job != null) {
            this.logger.debug(">> stopping virtualMachine(%s) job(%s)", new Object[]{virtualMachineId, job});
            this.awaitCompletion(job);
        }
    }
}

