/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.net.URI;
import org.jclouds.cloudstack.CloudStackApiMetadata;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.features.SessionClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="SessionClientExpectTest")
public class SessionClientExpectTest
extends BaseCloudStackExpectTest<SessionClient> {
    HttpRequest login = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"login"}).addQueryParam("username", new String[]{"jcloud"}).addQueryParam("domain", new String[]{"Partners/jCloud"}).addQueryParam("password", new String[]{"30e14b3727225d833aad2206acea1275"}).addHeader("Accept", new String[]{"application/json"})).build();

    public void testLoginWhenResponseIs2xxIncludesJSessionId() throws IOException {
        String domain = "Partners/jCloud";
        String user = "jcloud";
        String password = "jcl0ud";
        String md5password = BaseEncoding.base16().lowerCase().encode(Hashing.md5().hashString((CharSequence)password, Charsets.UTF_8).asBytes());
        String jSessionId = "90DD65D13AEAA590ECCA312D150B9F6D";
        SessionClient client = (SessionClient)this.requestSendsResponse(this.login, ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).headers((Multimap)ImmutableMultimap.builder().put((Object)"Set-Cookie", (Object)("JSESSIONID=" + jSessionId + "; Path=/client")).build())).payload(this.payloadFromResource("/loginresponse.json"))).build());
        Assert.assertEquals((String)client.loginUserInDomainWithHashOfPassword(user, domain, md5password).toString(), (String)LoginResponse.builder().timeout(1800L).lastName("Kiran").registered(false).username("jcloud").firstName("Vijay").domainId("11").accountType(Account.Type.DOMAIN_ADMIN).userId("19").sessionKey("uYT4/MNiglgAKiZRQkvV8QP8gn0=").jSessionId(jSessionId).accountName("jcloud").build().toString());
    }

    public void testLogout() throws IOException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=logout&sessionkey=dummy-session-key")).build();
        SessionClient client = (SessionClient)this.requestSendsResponse(request, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/logoutresponse.json"))).build());
        client.logoutUser("dummy-session-key");
    }

    @Override
    protected SessionClient clientFrom(CloudStackContext context) {
        return ((CloudStackClient)((RestContext)context.unwrap(CloudStackApiMetadata.CONTEXT_TOKEN)).getApi()).getSessionClient();
    }
}

