/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.features.SessionClient;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.domain.Credentials;

@Singleton
public class LoginWithPasswordCredentials
implements Function<Credentials, LoginResponse> {
    private final SessionClient client;

    @Inject
    public LoginWithPasswordCredentials(SessionClient client) {
        this.client = client;
    }

    public LoginResponse apply(Credentials input) {
        String username = input.identity;
        String domain = "";
        if (username.indexOf(47) != -1) {
            domain = username.substring(0, username.lastIndexOf(47));
            username = username.substring(username.lastIndexOf(47) + 1, username.length());
        }
        String hashedPassword = CryptoStreams.md5Hex((String)input.credential);
        return this.client.loginUserInDomainWithHashOfPassword(username, domain, hashedPassword);
    }

    public String toString() {
        return "loginWithPasswordCredentials()";
    }
}

